/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.actionresponse;

import java.time.Duration;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.models.RedirectRequestHandlerWithOpenUrlStrategy;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ActionResultResponseHandlingStrategy {
    REDIRECT_TO_PAGE{

        @Override
        public void handleResults(ActionResultResponse resultResponse) {
            MetaModelContext.instance().ifPresent(mmc -> mmc.getTransactionService().flushTransaction());
            resultResponse.pageRedirect().apply();
        }
    }
    ,
    SCHEDULE_HANDLER{

        @Override
        public void handleResults(ActionResultResponse resultResponse) {
            RequestCycle requestCycle = RequestCycle.get();
            AjaxRequestTarget ajaxTarget = requestCycle.find(AjaxRequestTarget.class).orElse(null);
            if (ajaxTarget == null) {
                requestCycle.scheduleRequestHandlerAfterCurrent(resultResponse.handler());
            } else {
                IRequestHandler requestHandler = resultResponse.handler();
                if (requestHandler instanceof ResourceStreamRequestHandler) {
                    ResourceStreamRequestHandler scheduledHandler = (ResourceStreamRequestHandler)requestHandler;
                    StreamAfterAjaxResponseBehavior streamingBehavior = new StreamAfterAjaxResponseBehavior(scheduledHandler);
                    Page page = ajaxTarget.getPage();
                    page.add(new Behavior[]{streamingBehavior});
                    CharSequence callbackUrl = streamingBehavior.getCallbackUrl();
                    ActionResultResponseHandlingStrategy.scheduleJs(ajaxTarget, ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(callbackUrl), 10);
                } else if (requestHandler instanceof RedirectRequestHandlerWithOpenUrlStrategy) {
                    RedirectRequestHandlerWithOpenUrlStrategy redirectHandler = (RedirectRequestHandlerWithOpenUrlStrategy)requestHandler;
                    String url = redirectHandler.getRedirectUrl();
                    String fullUrl = 2.expanded(requestCycle, url);
                    if (redirectHandler.getOpenUrlStrategy().isNewWindow()) {
                        ActionResultResponseHandlingStrategy.scheduleJs(ajaxTarget, ActionResultResponseHandlingStrategy.javascriptFor_newWindow(fullUrl), 100);
                    } else {
                        ActionResultResponseHandlingStrategy.scheduleJs(ajaxTarget, ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(fullUrl), 100);
                    }
                } else {
                    throw _Exceptions.unrecoverable((String)"no logic implemented to handle IRequestHandler of type %s", (Object[])new Object[]{requestHandler.getClass().getName()});
                }
            }
        }
    }
    ,
    OPEN_URL_IN_NEW_BROWSER_WINDOW{

        @Override
        public void handleResults(ActionResultResponse resultResponse) {
            String url = resultResponse.url();
            RequestCycle requestCycle = RequestCycle.get();
            String fullUrl = 3.expanded(requestCycle, url);
            ActionResultResponseHandlingStrategy.scheduleJs(resultResponse.ajaxTarget(), ActionResultResponseHandlingStrategy.javascriptFor_newWindow(fullUrl), 100);
        }
    }
    ,
    OPEN_URL_IN_SAME_BROWSER_WINDOW{

        @Override
        public void handleResults(ActionResultResponse resultResponse) {
            String url = resultResponse.url();
            RequestCycle requestCycle = RequestCycle.get();
            String fullUrl = 4.expanded(requestCycle, url);
            ActionResultResponseHandlingStrategy.scheduleJs(resultResponse.ajaxTarget(), ActionResultResponseHandlingStrategy.javascriptFor_sameWindow(fullUrl), 100);
        }
    };


    public abstract void handleResults(ActionResultResponse var1);

    public static String expanded(RequestCycle requestCycle, String url) {
        String urlStr = ActionResultResponseHandlingStrategy.expanded(url);
        return requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlStr));
    }

    public static String expanded(String urlStr) {
        if (urlStr.contains("antiCache=${currentTimeMillis}")) {
            urlStr = urlStr.replace("antiCache=${currentTimeMillis}", "antiCache=" + System.currentTimeMillis());
        }
        return urlStr;
    }

    private static String javascriptFor_newWindow(CharSequence url) {
        return "function(){Wicket.Event.publish(Causeway.Topic.OPEN_IN_NEW_TAB, '" + String.valueOf(url) + "');}";
    }

    private static String javascriptFor_sameWindow(CharSequence url) {
        return "\"window.location.href='" + String.valueOf(url) + "'\"";
    }

    private static void scheduleJs(AjaxRequestTarget target, String js, int millis) {
        target.appendJavaScript((CharSequence)String.format("setTimeout(%s, %d);", js, millis));
    }

    private static class StreamAfterAjaxResponseBehavior
    extends AbstractAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String fileName;
        private final IResourceStream resourceStream;
        private final Duration cacheDuration;

        public StreamAfterAjaxResponseBehavior(ResourceStreamRequestHandler scheduledHandler) {
            this.fileName = scheduledHandler.getFileName();
            this.resourceStream = scheduledHandler.getResourceStream();
            this.cacheDuration = scheduledHandler.getCacheDuration();
        }

        public void onRequest() {
            ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(this.resourceStream, this.fileName);
            handler.setCacheDuration(this.cacheDuration);
            handler.setContentDisposition(ContentDisposition.ATTACHMENT);
            Component page = this.getComponent();
            page.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            page.remove(new Behavior[]{this});
        }
    }
}

