/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.actionresponse;

import java.net.URL;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.applib.value.OpenUrlStrategy;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.PackedManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionResultModel;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.VoidModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelStandalone;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponseHandlingStrategy;
import org.apache.causeway.viewer.wicket.ui.actionresponse.PageRedirectRequest;
import org.apache.causeway.viewer.wicket.ui.actionresponse._DownloadHandler;
import org.apache.causeway.viewer.wicket.ui.actionresponse._RedirectHandler;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.causeway.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.causeway.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.springframework.lang.Nullable;

final class _ResponseUtil {
    static ActionResultResponse determineAndInterpretResult(@NonNull ActionModel actionModel, @Nullable AjaxRequestTarget ajaxTarget, @Nullable ManagedObject resultAdapterIfAny) {
        ActionResultResponse actionResultResponse;
        if (actionModel == null) {
            throw new NullPointerException("actionModel is marked non-null but is null");
        }
        ActionResultModel actionResultModel = ActionResultModel.determineFor((ActionModel)actionModel, (ManagedObject)resultAdapterIfAny, (AjaxRequestTarget)ajaxTarget);
        ActionResultResponse response = _ResponseUtil.actionResultResponse(actionModel, ajaxTarget, actionResultModel);
        if (response.pageRedirect() != null) {
            switch (actionModel.columnActionModifier()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    actionResultResponse = response;
                    break;
                }
                case FORCE_STAY_ON_PAGE: {
                    actionResultResponse = new ActionResultResponse(ActionResultResponseHandlingStrategy.OPEN_URL_IN_SAME_BROWSER_WINDOW, null, null, ajaxTarget, response.pageRedirect().toUrl());
                    break;
                }
                case FORCE_NEW_BROWSER_WINDOW: {
                    actionResultResponse = new ActionResultResponse(ActionResultResponseHandlingStrategy.OPEN_URL_IN_NEW_BROWSER_WINDOW, null, null, ajaxTarget, response.pageRedirect().toUrl());
                    break;
                }
            }
        } else {
            actionResultResponse = response;
        }
        return actionResultResponse;
    }

    private static ActionResultResponse actionResultResponse(@NonNull ActionModel actionModel, @Nullable AjaxRequestTarget ajaxTarget, @NonNull ActionResultModel actionResultModel) {
        if (actionModel == null) {
            throw new NullPointerException("actionModel is marked non-null but is null");
        }
        if (actionResultModel == null) {
            throw new NullPointerException("actionResultModel is marked non-null but is null");
        }
        FormExecutor.ActionResultResponseType responseType = actionResultModel.responseType();
        ManagedObject resultAdapter = actionResultModel.resultAdapter();
        switch (responseType) {
            case COLLECTION: {
                _Assert.assertTrue((boolean)(resultAdapter instanceof PackedManagedObject));
                CollectionModelStandalone collectionModel = CollectionModelStandalone.forActionModel((PackedManagedObject)((PackedManagedObject)resultAdapter), (ActionModel)actionModel);
                PageRedirectRequest<StandaloneCollectionPage> pageRedirectRequest = PageRedirectRequest.forPage(StandaloneCollectionPage.class, new StandaloneCollectionPage(collectionModel));
                return ActionResultResponse.toPage(pageRedirectRequest);
            }
            case OBJECT: {
                _ResponseUtil.determineScalarAdapter(actionModel.getMetaModelContext(), resultAdapter);
                return ActionResultResponse.toDomainObjectPage(resultAdapter);
            }
            case SIGN_IN: {
                Class<? extends Page> signInPage = ((PageClassRegistry)actionModel.getMetaModelContext().lookupServiceElseFail(PageClassRegistry.class)).getPageClass(PageType.SIGN_IN);
                PageRedirectRequest<? extends Page> pageRedirectRequest = PageRedirectRequest.forPageClass(signInPage);
                return ActionResultResponse.toPage(pageRedirectRequest);
            }
            case VALUE: {
                ValueModel valueModel = ValueModel.of((ObjectMember)actionModel.getAction(), (ManagedObject)resultAdapter);
                valueModel.setActionHint(actionModel);
                ValuePage valuePage = new ValuePage(valueModel);
                PageRedirectRequest<ValuePage> pageRedirectRequest = PageRedirectRequest.forPage(ValuePage.class, valuePage);
                return ActionResultResponse.toPage(pageRedirectRequest);
            }
            case VALUE_BLOB: {
                Object value = resultAdapter.getPojo();
                IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
                return ActionResultResponse.withHandler(handler);
            }
            case VALUE_CLOB: {
                Object value = resultAdapter.getPojo();
                IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
                return ActionResultResponse.withHandler(handler);
            }
            case VALUE_LOCALRESPATH_AJAX: {
                LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                return ActionResultResponse.openUrlInBrowser(ajaxTarget, localResPath.getEffectivePath(arg_0 -> ((WebAppContextPath)webAppContextPath).prependContextPath(arg_0)), localResPath.getOpenUrlStrategy());
            }
            case VALUE_LOCALRESPATH_NOAJAX: {
                LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                IRequestHandler handler = _RedirectHandler.redirectHandler(localResPath, localResPath.getOpenUrlStrategy(), webAppContextPath);
                return ActionResultResponse.withHandler(handler);
            }
            case VALUE_URL_AJAX: {
                URL url = (URL)resultAdapter.getPojo();
                return ActionResultResponse.openUrlInBrowser(ajaxTarget, url.toString(), OpenUrlStrategy.NEW_WINDOW);
            }
            case VALUE_URL_NOAJAX: {
                Object value = resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                IRequestHandler handler = _RedirectHandler.redirectHandler(value, OpenUrlStrategy.NEW_WINDOW, webAppContextPath);
                return ActionResultResponse.withHandler(handler);
            }
            case VOID_AS_EMPTY: {
                PageRedirectRequest<VoidReturnPage> pageRedirectRequest = PageRedirectRequest.forPage(VoidReturnPage.class, new VoidReturnPage(new VoidModel(), actionModel.getFriendlyName()));
                return ActionResultResponse.toPage(pageRedirectRequest);
            }
            case RELOAD: {
                IRequestablePage currentPage = PageRequestHandlerTracker.getLastHandler((RequestCycle)RequestCycle.get()).getPage();
                Class pageClass = currentPage.getClass();
                PageRedirectRequest<IRequestablePage> pageRedirectRequest = PageRedirectRequest.forPage(pageClass, (IRequestablePage)_Casts.uncheckedCast((Object)currentPage));
                return ActionResultResponse.toPage(pageRedirectRequest);
            }
        }
        throw _Exceptions.unmatchedCase((Object)responseType);
    }

    private static ManagedObject determineScalarAdapter(@NonNull MetaModelContext mmc, @NonNull ManagedObject resultAdapter) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (resultAdapter == null) {
            throw new NullPointerException("resultAdapter is marked non-null but is null");
        }
        if (resultAdapter.getSpecification().isSingular()) {
            return resultAdapter;
        }
        Object pojo = _NullSafe.streamAutodetect((Object)resultAdapter.getPojo()).findFirst().orElseThrow(_Exceptions::noSuchElement);
        ManagedObject scalarAdapter = mmc.getObjectManager().adapt(pojo);
        return scalarAdapter;
    }

    @Generated
    private _ResponseUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

