/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.LabelPosition;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.debug._Probe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeModelChangeDispatcher;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeModelChangeListener;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeModelDefaultChangeBehavior;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.components.attributes._Util;
import org.apache.causeway.viewer.wicket.ui.components.attributes._Xray;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public abstract class AttributePanel
extends PanelAbstract<ManagedObject, UiAttributeWkt>
implements AttributeModelChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected static final String ID_SCALAR_NAME_BEFORE_VALUE = "scalarNameBeforeValue";
    protected static final String ID_SCALAR_NAME_AFTER_VALUE = "scalarNameAfterValue";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_XRAY_DETAILS = "xrayDetails";
    private final ImmutableEnumSet<FormatModifier> formatModifiers;
    private Component compactFrame;
    private MarkupContainer regularFrame;
    private WebMarkupContainer formFrame;
    private WebMarkupContainer scalarFrameContainer;
    private final RenderScenario renderScenario;
    private final AttributeModelChangeDispatcher attributeModelChangeDispatcher = new AttributeModelChangeDispatcherImpl(this);

    public final UiAttributeWkt attributeModel() {
        return (UiAttributeWkt)super.getModel();
    }

    protected void setupFormatModifiers(EnumSet<FormatModifier> modifiers) {
    }

    protected abstract Component createCompactFrame();

    protected abstract MarkupContainer createRegularFrame();

    protected final WebMarkupContainer getScalarFrameContainer() {
        return this.scalarFrameContainer;
    }

    protected AttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
        EnumSet<FormatModifier> formatModifiers = EnumSet.noneOf(FormatModifier.class);
        this.setupFormatModifiers(formatModifiers);
        this.formatModifiers = ImmutableEnumSet.from(formatModifiers);
        this.renderScenario = RenderScenario.inferFrom(this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
        this.callHooks();
        this.setOutputMarkupId(true);
    }

    public final String getCssClassName() {
        return _Strings.decapitalize((String)this.getClass().getSimpleName());
    }

    private void buildGui() {
        UiAttributeWkt attributeModel = this.attributeModel();
        this.scalarFrameContainer = Wkt.containerAdd((MarkupContainer)this, ID_SCALAR_TYPE_CONTAINER);
        Wkt.cssAppend(this.scalarFrameContainer, this.getCssClassName());
        if (attributeModel.getRenderingHint().isInTable()) {
            this.regularFrame = this.createShallowRegularFrame();
            this.compactFrame = this.createCompactFrame();
            this.regularFrame.setVisible(false);
            this.compactFrame.setVisible(true);
            Component[] componentArray = new Component[3];
            componentArray[0] = this.compactFrame;
            componentArray[1] = this.regularFrame;
            this.formFrame = this.createFormFrame();
            componentArray[2] = this.formFrame;
            this.scalarFrameContainer.addOrReplace(componentArray);
        } else {
            this.regularFrame = Wkt.ajaxEnable(this.createRegularFrame());
            this.compactFrame = this.createShallowCompactFrame();
            this.regularFrame.setVisible(true);
            this.compactFrame.setVisible(false);
            Component[] componentArray = new Component[3];
            componentArray[0] = this.compactFrame;
            componentArray[1] = this.regularFrame;
            this.formFrame = this.createFormFrame();
            componentArray[2] = this.formFrame;
            this.scalarFrameContainer.addOrReplace(componentArray);
            Can<ActionModel> associatedLinksAndLabels = _Util.associatedActionModels(attributeModel);
            this.addPositioningCssTo(this.regularFrame, associatedLinksAndLabels);
            this.addActionLinksBelowAndRight(this.regularFrame, associatedLinksAndLabels);
            this.addFeedbackOnlyTo(this.regularFrame, this.getValidationFeedbackReceiver());
            this.setupInlinePrompt();
        }
        if (_Util.isPropertyWithEnterEditNotAvailable(attributeModel)) {
            Wkt.noTabbing(this.getValidationFeedbackReceiver());
        }
        this.addCssFromMetaModel();
        this.addChangeListener(this);
        this.installModelChangeBehavior();
    }

    protected abstract void setupInlinePrompt();

    protected MarkupContainer createShallowRegularFrame() {
        WebMarkupContainer shallowRegularFrame = AttributeFragmentFactory.FrameFragment.REGULAR.createComponent(Wkt::container);
        WktComponents.permanentlyHide((MarkupContainer)shallowRegularFrame, ID_SCALAR_NAME_BEFORE_VALUE, ID_SCALAR_VALUE, ID_SCALAR_NAME_AFTER_VALUE, AttributeFragmentFactory.RegularFrame.FIELD.getContainerId(), AttributeFragmentFactory.RegularFrame.FEEDBACK.getContainerId(), AttributeFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), AttributeFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId());
        return shallowRegularFrame;
    }

    protected Component createShallowCompactFrame() {
        return AttributeFragmentFactory.FrameFragment.COMPACT.createComponent(Wkt::container);
    }

    protected WebMarkupContainer createFormFrame() {
        boolean isNotInTable = this.attributeModel().getRenderingHint().isNotInTable();
        return (WebMarkupContainer)AttributeFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.createComponent(WebMarkupContainer::new).setVisible(false).setOutputMarkupId(isNotInTable);
    }

    protected final void switchRegularFrameToFormFrame() {
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this.getScalarFrameContainer(), AttributeFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.getContainerId(), UiComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.attributeModel());
        this.getRegularFrame().setVisible(false);
        this.getFormFrame().setVisible(true);
    }

    private void callHooks() {
        UiAttributeWkt attributeModel = this.attributeModel();
        if (attributeModel.disabledReason().isPresent()) {
            boolean isOrCanBeSwitchedToEditable;
            boolean bl = isOrCanBeSwitchedToEditable = attributeModel.isEditingMode() || attributeModel.isParameter() || attributeModel.hasAssociatedActionWithInlineAsIfEdit();
            if (isOrCanBeSwitchedToEditable) {
                this.onInitializeNotEditable();
            } else {
                String disabledReason = (String)attributeModel.disabledReason().flatMap(InteractionVeto::getReasonAsString).orElseThrow(() -> _Exceptions.unrecoverable((String)"framework bug: AttributeModel indicates it has a disabled-reason, yet its empty"));
                this.onInitializeReadonly(disabledReason);
            }
        } else if (attributeModel.isViewingMode()) {
            this.onInitializeNotEditable();
        } else {
            this.onInitializeEditable();
        }
    }

    protected void onInitializeNotEditable() {
    }

    protected void onInitializeReadonly(String disableReason) {
    }

    protected void onInitializeEditable() {
    }

    protected abstract void onMakeNotEditable(String var1);

    protected abstract void onMakeEditable();

    private void addCssFromMetaModel() {
        UiAttributeWkt attributeModel = this.attributeModel();
        Wkt.cssAppend(this, attributeModel.getCssClass());
        Facets.cssClass((FacetHolder)attributeModel.getMetaModel(), (ManagedObject)attributeModel.getParentUiModel().getManagedObject()).ifPresent(cssClass -> Wkt.cssAppend(this, cssClass));
    }

    protected void onConfigure() {
        boolean hidden = this.attributeModel().whetherHidden();
        this.setVisibilityAllowed(!hidden);
        super.onConfigure();
    }

    protected void installModelChangeBehavior() {
        this.addOrReplaceBehavoir(AttributeModelDefaultChangeBehavior.class, () -> new AttributeModelDefaultChangeBehavior(this));
    }

    public void addChangeListener(AttributeModelChangeListener listener) {
        ((AttributeModelChangeDispatcherImpl)this.getAttributeModelChangeDispatcher()).addChangeListener(listener);
    }

    protected final <T extends Behavior> void addOrReplaceBehavoir(@NonNull Class<T> behaviorClass, @NonNull Supplier<T> factory) {
        if (behaviorClass == null) {
            throw new NullPointerException("behaviorClass is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Component validationFeedbackReceiver = this.getValidationFeedbackReceiver();
        if (validationFeedbackReceiver == null) {
            return;
        }
        for (Behavior behavior : validationFeedbackReceiver.getBehaviors(behaviorClass)) {
            validationFeedbackReceiver.remove(new Behavior[]{behavior});
        }
        validationFeedbackReceiver.add(new Behavior[]{(Behavior)factory.get()});
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, AttributePanel scalarPanel) {
        if (((UiAttributeWkt)this.getModel()).isParameter()) {
            Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
        }
    }

    @Override
    public void onError(AjaxRequestTarget target, AttributePanel scalarPanel) {
    }

    protected final void scalarNameLabelAddTo(MarkupContainer container, IModel<String> labelCaption) {
        UiAttributeWkt attributeModel = this.attributeModel();
        ScalarNameHelper helper = ScalarNameHelper.from(attributeModel);
        helper.hideHiddenLabels(container);
        helper.visibleLabelId.ifPresent(visibleLabelId -> {
            Label scalarNameLabel = Wkt.labelAdd(container, visibleLabelId, labelCaption);
            if (_Strings.isNullOrEmpty((CharSequence)((CharSequence)labelCaption.getObject()))) {
                return;
            }
            WktDecorators.formLabel().decorate((Component)scalarNameLabel, FormLabelDecorator.FormLabelDecorationModel.mandatory((boolean)attributeModel.isShowMandatoryIndicator()));
            attributeModel.getDescribedAs().ifPresent(describedAs -> WktTooltips.addTooltip(scalarNameLabel, describedAs));
        });
    }

    @Nullable
    protected abstract Component getValidationFeedbackReceiver();

    private void addFeedbackOnlyTo(MarkupContainer markupContainer, Component component) {
        if (component == null) {
            return;
        }
        markupContainer.addOrReplace(new Component[]{AttributeFragmentFactory.RegularFrame.FEEDBACK.createComponent(id -> new NotificationPanel(id, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component)))});
    }

    private void addActionLinksBelowAndRight(MarkupContainer labelIfRegular, Can<ActionModel> actionModels) {
        Can linksBelow = actionModels.filter(ActionModel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.BELOW));
        ActionLinksPanel.addActionLinks(labelIfRegular, AttributeFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), (Can<ActionModel>)linksBelow, ActionLinksPanel.Style.INLINE_LIST);
        Can linksRight = actionModels.filter(ActionModel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT));
        ActionLinksPanel.addActionLinks(labelIfRegular, AttributeFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId(), (Can<ActionModel>)linksRight, ActionLinksPanel.Style.DROPDOWN);
    }

    private void addPositioningCssTo(MarkupContainer markupContainer, Can<ActionModel> actionLinks) {
        Wkt.cssAppend(markupContainer, AttributePanel.determinePropParamLayoutCss((UiAttributeWkt)this.getModel()));
        Wkt.cssAppend(markupContainer, AttributePanel.determineActionLayoutPositioningCss(actionLinks));
    }

    private static String determinePropParamLayoutCss(UiAttributeWkt attributeModel) {
        return Facets.labelAtCss((ObjectFeature)attributeModel.getMetaModel());
    }

    private static String determineActionLayoutPositioningCss(Can<ActionModel> entityActionLinks) {
        return entityActionLinks.stream().anyMatch(ActionModel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT)) ? "actions-right" : null;
    }

    public Repaint updateIfNecessary(@NonNull UiParameter paramModel) {
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        boolean visibilityBefore = this.isVisibilityAllowed();
        boolean usabilityBefore = this.isCurrentlyRenderedAsUsable();
        ParameterNegotiationModel paramNegotiationModel = paramModel.getParameterNegotiationModel();
        int paramIndex = paramModel.getParameterIndex();
        paramNegotiationModel.invalidateVisibilityAndUsability(paramIndex);
        Consent visibilityConsent = paramNegotiationModel.getVisibilityConsent(paramIndex);
        boolean visibilityAfter = visibilityConsent.isAllowed();
        this.setVisibilityAllowed(visibilityAfter);
        Consent usabilityConsent = paramNegotiationModel.getUsabilityConsent(paramIndex);
        boolean usabilityAfter = usabilityConsent.isAllowed();
        if (usabilityAfter) {
            this.onMakeEditable();
        } else {
            this.onMakeNotEditable(usabilityConsent.getReasonAsString().orElse(null));
        }
        if (visibilityBefore != visibilityAfter) {
            return visibilityAfter ? Repaint.REQUIRED_ON_PARENT : Repaint.REQUIRED;
        }
        if (usabilityBefore != usabilityAfter && visibilityAfter) {
            return Repaint.REQUIRED;
        }
        return Repaint.OPTIONAL;
    }

    private boolean isCurrentlyRenderedAsUsable() {
        if (!this.isEnabled()) {
            return false;
        }
        return _Casts.castTo(AttributePanelWithFormField.class, (Object)this).map(AttributePanelWithFormField::getFormComponent).map(Component::isEnabled).orElse(true);
    }

    @Generated
    public ImmutableEnumSet<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    @Generated
    protected Component getCompactFrame() {
        return this.compactFrame;
    }

    @Generated
    protected MarkupContainer getRegularFrame() {
        return this.regularFrame;
    }

    @Generated
    protected WebMarkupContainer getFormFrame() {
        return this.formFrame;
    }

    @Generated
    protected RenderScenario getRenderScenario() {
        return this.renderScenario;
    }

    @Generated
    public AttributeModelChangeDispatcher getAttributeModelChangeDispatcher() {
        return this.attributeModelChangeDispatcher;
    }

    static class AttributeModelChangeDispatcherImpl
    implements AttributeModelChangeDispatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<AttributeModelChangeListener> changeListeners = _Lists.newArrayList();
        private final AttributePanel scalarPanel;

        @Override
        public void notifyUpdate(AjaxRequestTarget target) {
            _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User either having changed a Property value during inline editing or having changed a Parameter value within an open ActionPrompt.");
            _Xray.onParamOrPropertyEdited(this.scalarPanel);
            AttributeModelChangeDispatcher.super.notifyUpdate(target);
        }

        @Override
        @NonNull
        public Iterable<AttributeModelChangeListener> getChangeListeners() {
            return Collections.unmodifiableCollection(this.changeListeners);
        }

        void addChangeListener(AttributeModelChangeListener listener) {
            this.changeListeners.add(listener);
        }

        @Generated
        public AttributeModelChangeDispatcherImpl(AttributePanel scalarPanel) {
            this.scalarPanel = scalarPanel;
        }

        @Override
        @Generated
        public AttributePanel getScalarPanel() {
            return this.scalarPanel;
        }
    }

    public static enum FormatModifier {
        MARKUP,
        MULTILINE,
        TEXT_ONLY;

    }

    public static enum RenderScenario {
        COMPACT,
        READONLY,
        CAN_EDIT,
        CAN_EDIT_INLINE,
        CAN_EDIT_INLINE_VIA_ACTION,
        EDITING,
        EDITING_WITH_LINK_TO_NESTED;


        public boolean isCompact() {
            return this == COMPACT;
        }

        public boolean isReadonly() {
            return this == READONLY;
        }

        public boolean isCanEdit() {
            return this == CAN_EDIT;
        }

        public boolean isEditing() {
            return this == EDITING;
        }

        public boolean isEditingAny() {
            return this == EDITING || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        public boolean isViewingAndCanEditAny() {
            return this == CAN_EDIT || this == CAN_EDIT_INLINE || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        static RenderScenario inferFrom(AttributePanel scalarPanel) {
            UiAttributeWkt attributeModel = scalarPanel.attributeModel();
            if (attributeModel.getRenderingHint().isInTable()) {
                return COMPACT;
            }
            if (attributeModel.isParameter()) {
                return _Util.canParameterEnterNestedEdit(attributeModel) ? EDITING_WITH_LINK_TO_NESTED : EDITING;
            }
            if (attributeModel.isEditingMode()) {
                return EDITING;
            }
            if (_Util.canPropertyEnterInlineEditDirectly(attributeModel)) {
                return CAN_EDIT_INLINE;
            }
            if (_Util.lookupPropertyActionForInlineEdit(attributeModel).isPresent()) {
                return CAN_EDIT_INLINE_VIA_ACTION;
            }
            return attributeModel.disabledReason().isPresent() ? READONLY : CAN_EDIT;
        }
    }

    private static final class ScalarNameHelper {
        private final Optional<String> visibleLabelId;
        private final String[] hiddenLabelIds;

        static ScalarNameHelper from(UiAttributeWkt attributeModel) {
            LabelPosition labelPostion = Facets.labelAt((ObjectFeature)attributeModel.getMetaModel());
            return labelPostion == LabelPosition.NONE ? new ScalarNameHelper(Optional.empty(), new String[]{AttributePanel.ID_SCALAR_NAME_BEFORE_VALUE, AttributePanel.ID_SCALAR_NAME_AFTER_VALUE}) : (labelPostion == LabelPosition.RIGHT ? new ScalarNameHelper(Optional.of(AttributePanel.ID_SCALAR_NAME_AFTER_VALUE), new String[]{AttributePanel.ID_SCALAR_NAME_BEFORE_VALUE}) : new ScalarNameHelper(Optional.of(AttributePanel.ID_SCALAR_NAME_BEFORE_VALUE), new String[]{AttributePanel.ID_SCALAR_NAME_AFTER_VALUE}));
        }

        void hideHiddenLabels(MarkupContainer container) {
            for (String hiddenLabelId : this.hiddenLabelIds) {
                WktComponents.permanentlyHide(container, hiddenLabelId);
            }
        }

        @Generated
        public ScalarNameHelper(Optional<String> visibleLabelId, String[] hiddenLabelIds) {
            this.visibleLabelId = visibleLabelId;
            this.hiddenLabelIds = hiddenLabelIds;
        }

        @Generated
        public Optional<String> getVisibleLabelId() {
            return this.visibleLabelId;
        }

        @Generated
        public String[] getHiddenLabelIds() {
            return this.hiddenLabelIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalarNameHelper)) {
                return false;
            }
            ScalarNameHelper other = (ScalarNameHelper)o;
            Optional<String> this$visibleLabelId = this.getVisibleLabelId();
            Optional<String> other$visibleLabelId = other.getVisibleLabelId();
            if (this$visibleLabelId == null ? other$visibleLabelId != null : !((Object)this$visibleLabelId).equals(other$visibleLabelId)) {
                return false;
            }
            return Arrays.deepEquals(this.getHiddenLabelIds(), other.getHiddenLabelIds());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $visibleLabelId = this.getVisibleLabelId();
            result = result * 59 + ($visibleLabelId == null ? 43 : ((Object)$visibleLabelId).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getHiddenLabelIds());
            return result;
        }

        @Generated
        public String toString() {
            return "AttributePanel.ScalarNameHelper(visibleLabelId=" + String.valueOf(this.getVisibleLabelId()) + ", hiddenLabelIds=" + Arrays.deepToString(this.getHiddenLabelIds()) + ")";
        }
    }

    public static enum Repaint {
        OPTIONAL,
        REQUIRED,
        REQUIRED_ON_PARENT;


        public static Repaint required(boolean needsRepainting) {
            return needsRepainting ? REQUIRED : OPTIONAL;
        }

        public boolean isOptional() {
            return this == OPTIONAL;
        }

        public boolean isRequired() {
            return this == REQUIRED;
        }

        public boolean isRequiredOnParent() {
            return this == REQUIRED_ON_PARENT;
        }

        public Repaint max(@NonNull Repaint other) {
            if (other == null) {
                throw new NullPointerException("other is marked non-null but is null");
            }
            return this.ordinal() >= other.ordinal() ? this : other;
        }
    }
}

