/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.markup;

import java.io.Serializable;
import org.apache.causeway.applib.value.Markup;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeComponentFactoryWithTypeConstraint;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.MarkupAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.MarkupComponent;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.StandaloneMarkupPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class MarkupAttributePanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Parented
    extends ParentedAbstract<Markup> {
        public Parented() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponent newMarkupComponent(String id, UiAttributeWkt model) {
            MarkupComponent markupComponent = new MarkupComponent(id, (IModel<?>)model);
            markupComponent.setEnabled(false);
            return markupComponent;
        }
    }

    static class Standalone
    extends StandaloneAbstract<Markup> {
        public Standalone() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponent newMarkupComponent(String id, ValueModel model) {
            return new MarkupComponent(id, (IModel<?>)model);
        }
    }

    public static abstract class StandaloneAbstract<T>
    extends ComponentFactoryAbstract {
        private final Class<T> valueType;

        public StandaloneAbstract(Class<T> valueType) {
            super(UiComponentType.VALUE, StandaloneMarkupPanel.class);
            this.valueType = valueType;
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ValueModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ValueModel valueModel = (ValueModel)model;
            ManagedObject objectAdapter = (ManagedObject)valueModel.getObject();
            if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)objectAdapter)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(this.valueType.isAssignableFrom(objectAdapter.getSpecification().getCorrespondingClass()));
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneMarkupPanel(id, (ValueModel)model, this::newMarkupComponent);
        }

        protected abstract MarkupComponent newMarkupComponent(String var1, ValueModel var2);
    }

    public static abstract class ParentedAbstract<T extends Serializable>
    extends AttributeComponentFactoryWithTypeConstraint {
        private final Class<T> valueType;

        protected ParentedAbstract(Class<T> valueType) {
            super(MarkupAttributePanel.class, valueType);
            this.valueType = valueType;
        }

        @Override
        protected Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new MarkupAttributePanel<T>(id, attributeModel, this.valueType, this.key());
        }

        protected abstract MarkupComponent newMarkupComponent(String var1, UiAttributeWkt var2);
    }
}

