/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.icons;

import java.util.List;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.ui.components.object.header.ObjectHeaderPanel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.RepeatingView;

class CollectionContentsAsIconsPanel
extends PanelAbstract<DataTableInteractive, CollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OBJECT_INSTANCE = "objectInstance";

    public CollectionContentsAsIconsPanel(String id, CollectionModel model) {
        super(id, model);
        this.buildGui();
    }

    private void buildGui() {
        CollectionModel model = (CollectionModel)this.getModel();
        List visibleAdapters = ((Can)model.getDataTableModel().dataRowsFilteredAndSortedObservable().getValue()).map(DataRow::rowElement).toList();
        RepeatingView entityInstances = new RepeatingView(ID_OBJECT_INSTANCE);
        this.add(new Component[]{entityInstances});
        for (ManagedObject adapter : visibleAdapters) {
            String childId = entityInstances.newChildId();
            UiObjectWkt objectModel = UiObjectWkt.ofAdapter((ManagedObject)adapter);
            ObjectHeaderPanel entitySummaryPanel = new ObjectHeaderPanel(childId, objectModel);
            entityInstances.add(new Component[]{entitySummaryPanel});
        }
    }
}

