/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationChoice;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public record CollectionPresentationSelectorHelper(CollectionModel collectionModel, Can<ComponentFactoryKey> factoryKeys, ComponentHintKey componentHintKey) implements Serializable
{
    static final String UIHINT_EVENT_VIEW_KEY = "selectedItem";

    public CollectionPresentationSelectorHelper(CollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry) {
        this(collectionModel, componentFactoryRegistry, ComponentHintKey.noop());
    }

    public CollectionPresentationSelectorHelper(CollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry, ComponentHintKey componentHintKey) {
        this(collectionModel, CollectionPresentationSelectorHelper.gatherComponentFactories(componentFactoryRegistry, collectionModel), componentHintKey != null ? componentHintKey : ComponentHintKey.noop());
    }

    public String honourViewHintElseDefault(Component component) {
        String viewStr;
        UiHintContainer hintContainer = CollectionPresentationSelectorHelper.getUiHintContainer(component);
        if (hintContainer != null && (viewStr = hintContainer.getHint(component, UIHINT_EVENT_VIEW_KEY)) != null) {
            return viewStr;
        }
        String initialFactory = this.determineInitialFactory();
        if (hintContainer != null) {
            hintContainer.setHint(component, UIHINT_EVENT_VIEW_KEY, initialFactory);
        }
        return initialFactory;
    }

    Can<CollectionPresentationChoice> collectionPresentationChoices() {
        return this.factoryKeys.map(k -> CollectionPresentationChoice.of(k.componentFactory()));
    }

    CollectionPresentationChoice find(Can<CollectionPresentationChoice> presentationChoices, String selected) {
        CollectionPresentationChoice componentFactory = this.doFind(presentationChoices, selected);
        if (componentFactory != null) {
            return componentFactory;
        }
        String fallback = this.collectionModel.getVariant().isParented() ? "hidden" : "table";
        componentFactory = this.doFind(presentationChoices, fallback);
        if (componentFactory == null) {
            throw new IllegalStateException(String.format("Could not locate '%s' (as the fallback collection panel)", fallback));
        }
        return componentFactory;
    }

    private String determineInitialFactory() {
        String defaultView;
        Bookmark bookmark = this.collectionModel.parentedHintingBookmark().orElse(null);
        String sessionAttribute = this.componentHintKey.get(bookmark);
        if (sessionAttribute != null) {
            return sessionAttribute;
        }
        CollectionLayoutData layoutData = CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(this.collectionModel).map(CollectionModelParented::getLayoutData).orElse(null);
        if (layoutData != null && (defaultView = layoutData.getDefaultView()) != null) {
            return defaultView;
        }
        if (CollectionPresentationSelectorHelper.hasDefaultViewFacet(this.collectionModel)) {
            String viewName = (String)Facets.defaultViewName((ObjectFeature)this.collectionModel.getMetaModel()).orElseThrow();
            for (ComponentFactoryKey componentFactory : this.factoryKeys) {
                String componentName = componentFactory.id();
                if (!componentName.equalsIgnoreCase(viewName)) continue;
                return componentName;
            }
        }
        return CollectionPresentationSelectorHelper.hasRenderEagerlySemantics(this.collectionModel) || this.collectionModel.getVariant().isStandalone() ? "table" : "hidden";
    }

    private static UiHintContainer getUiHintContainer(Component component) {
        return UiHintContainer.Util.hintContainerOf((Component)component, CollectionModelParented.class);
    }

    private static boolean hasRenderEagerlySemantics(IModel<?> model) {
        return CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(model).map(CollectionModelParented::getMetaModel).map(Facets::defaultViewIsTable).orElse(false);
    }

    private static boolean hasDefaultViewFacet(IModel<?> model) {
        return CollectionPresentationSelectorHelper.toParentedEntityCollectionModel(model).map(CollectionModelParented::getMetaModel).map(Facets::defaultViewIsPresent).orElse(false);
    }

    private CollectionPresentationChoice doFind(Can<CollectionPresentationChoice> presentationChoices, String selected) {
        for (CollectionPresentationChoice componentFactory : presentationChoices) {
            if (!selected.equals(componentFactory.id())) continue;
            return componentFactory;
        }
        return null;
    }

    public int lookup(String view) {
        int i = 0;
        for (ComponentFactoryKey componentFactory : this.factoryKeys) {
            if (view.equals(componentFactory.id())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static Optional<CollectionModelParented> toParentedEntityCollectionModel(@Nullable IModel<?> model) {
        if (model instanceof CollectionModelParented) {
            return Optional.of((CollectionModelParented)model);
        }
        return Optional.empty();
    }

    private static Can<ComponentFactoryKey> gatherComponentFactories(ComponentFactoryRegistry componentFactoryRegistry, CollectionModel collectionModel) {
        return (Can)componentFactoryRegistry.streamComponentFactories((ImmutableEnumSet<UiComponentType>)ImmutableEnumSet.of((Enum)UiComponentType.COLLECTION_CONTENTS, (Enum)UiComponentType.COLLECTION_CONTENTS_EXPORT), (IModel<?>)collectionModel).filter(componentFactory -> componentFactory.getClass() != CollectionContentsMultipleViewsPanelFactory.class).map(ComponentFactory::key).collect(Can.toCan());
    }
}

