/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.object;

import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.model.IModel;

public abstract class ObjectComponentFactoryAbstract
extends ComponentFactoryAbstract {
    public ObjectComponentFactoryAbstract(UiComponentType uiComponentType, Class<?> componentClass) {
        super(uiComponentType, componentClass);
    }

    public ObjectComponentFactoryAbstract(UiComponentType uiComponentType, String name, Class<?> componentClass) {
        super(uiComponentType, name, componentClass);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        ObjectSpecification spec;
        if (!(model instanceof UiObjectWkt)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        UiObjectWkt objectModel = (UiObjectWkt)model;
        ManagedObject adapter = objectModel.getManagedObject();
        if (adapter == null) {
            // empty if block
        }
        if ((spec = objectModel.getTypeOfSpecification()).isSingular() && !spec.isValue()) {
            return this.doAppliesTo(objectModel);
        }
        return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    protected ComponentFactory.ApplicationAdvice doAppliesTo(UiObjectWkt objectModel) {
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }
}

