/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.object.fieldset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.layout.component.FieldSet;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

public class PropertyGroup
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_MEMBER_GROUP = "memberGroup";
    private static final String ID_MEMBER_GROUP_NAME = "memberGroupName";
    private static final String ID_ASSOCIATED_ACTION_LINKS_PANEL = "associatedActionLinksPanel";
    private static final String ID_ASSOCIATED_ACTION_LINKS_PANEL_DROPDOWN = "associatedActionLinksPanelDropDown";
    private static final String ID_PROPERTIES = "properties";
    private static final String ID_PROPERTY = "property";
    private final FieldSet fieldSet;
    private final Can<AttributePanel> childScalarPanels;
    private final List<Component> childComponents;

    public PropertyGroup(String id, UiObjectWkt model, FieldSet fieldSet) {
        super(id, model);
        this.fieldSet = fieldSet;
        this.childComponents = this.buildGui();
        this.childScalarPanels = (Can)_NullSafe.stream(this.childComponents).filter(AttributePanel.class::isInstance).map(AttributePanel.class::cast).collect(Can.toCan());
    }

    @Override
    public UiObjectWkt getModel() {
        return (UiObjectWkt)this.getDefaultModel();
    }

    private List<Component> buildGui() {
        ArrayList childComponents = _Lists.newArrayList();
        this.setOutputMarkupPlaceholderTag(true);
        this.setOutputMarkupId(true);
        WebMarkupContainer div = new WebMarkupContainer(ID_MEMBER_GROUP);
        div.setMarkupId("fieldSet-" + this.fieldSet.getId());
        RepeatingView propertyRv = new RepeatingView(ID_PROPERTIES);
        div.addOrReplace(new Component[]{propertyRv});
        Can<OneToOneAssociation> properties = this.getPropertiesNotStaticallyHidden();
        Can<ActionModel> memberGroupActions = this.collectMemberGroupActions(propertyRv, childComponents::add);
        WebMarkupContainer panelHeading = new WebMarkupContainer("panelHeading");
        div.addOrReplace(new Component[]{panelHeading});
        if (_Strings.isNullOrEmpty((CharSequence)this.fieldSet.getName())) {
            panelHeading.setVisibilityAllowed(false);
        } else {
            Wkt.labelAdd((MarkupContainer)panelHeading, ID_MEMBER_GROUP_NAME, this.fieldSet.getName());
            ActionLinksPanel.addActionLinks((MarkupContainer)panelHeading, ID_ASSOCIATED_ACTION_LINKS_PANEL, (Can<ActionModel>)memberGroupActions.filter(ActionModel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.PANEL)), ActionLinksPanel.Style.INLINE_LIST);
            ActionLinksPanel.addActionLinks((MarkupContainer)panelHeading, ID_ASSOCIATED_ACTION_LINKS_PANEL_DROPDOWN, (Can<ActionModel>)memberGroupActions.filter(ActionModel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.PANEL_DROPDOWN)), ActionLinksPanel.Style.DROPDOWN);
        }
        if (properties.isEmpty()) {
            WktComponents.permanentlyHide((MarkupContainer)this, div.getId());
        } else {
            this.addOrReplace(new Component[]{div});
        }
        return childComponents;
    }

    private Can<ActionModel> collectMemberGroupActions(RepeatingView container, Consumer<Component> onNewChildComponent) {
        ArrayList memberGroupActionList = _Lists.newArrayList();
        for (OneToOneAssociation property : this.getPropertiesNotStaticallyHidden()) {
            WebMarkupContainer propertyRvContainer = new WebMarkupContainer(container.newChildId());
            container.addOrReplace(new Component[]{propertyRvContainer});
            onNewChildComponent.accept(this.addPropertyToForm(this.getModel(), property, propertyRvContainer, memberGroupActionList::add));
        }
        return Can.ofCollection((Collection)memberGroupActionList);
    }

    private Can<OneToOneAssociation> getPropertiesNotStaticallyHidden() {
        ManagedObject entity = this.getModel().getManagedObject();
        List propertyLayouts = this.fieldSet.getProperties();
        return (Can)_NullSafe.stream((Collection)propertyLayouts).filter(propertyLayoutData -> propertyLayoutData.getMetadataError() == null).map(propertyLayoutData -> entity.getSpecification().getProperty(propertyLayoutData.getId()).orElse(null)).filter(_NullSafe::isPresent).filter(Facets.hiddenWhereMatches(where -> where.isAlways() || where == Where.OBJECT_FORMS).negate()).collect(Can.toCan());
    }

    private Component addPropertyToForm(UiObjectWkt objectModel, OneToOneAssociation property, WebMarkupContainer container, Consumer<ActionModel> onAssociatedAction) {
        UiAttributeWkt attributeModel = objectModel.getPropertyModel(property, ViewOrEditMode.VIEWING, RenderingHint.REGULAR);
        Component scalarNameAndValueComponent = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ID_PROPERTY, UiComponentType.ATTRIBUTE_NAME_AND_VALUE, (IModel<?>)attributeModel);
        ManagedObject entity = objectModel.getManagedObject();
        ObjectAction.Util.findForAssociation((ManagedObject)entity, (ObjectAssociation)property).map(act -> ActionModel.forEntity((ObjectAction)act, (UiObjectWkt)objectModel)).forEach(onAssociatedAction);
        return scalarNameAndValueComponent;
    }

    public void onConfigure() {
        for (AttributePanel childComponent : this.childScalarPanels) {
            childComponent.configure();
        }
        super.onConfigure();
    }

    @Override
    public boolean isVisible() {
        if (this.childComponents.size() > this.childScalarPanels.size()) {
            return true;
        }
        for (AttributePanel childComponent : this.childScalarPanels) {
            if (!childComponent.isVisibilityAllowed()) continue;
            return true;
        }
        return false;
    }
}

