/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.filter;

import java.io.Serializable;
import lombok.Generated;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class FilterToolbar
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE_SEARCH_INPUT = "table-search-input";
    private static final String ID_TABLE_SEARCH_BUTTON = "table-search-button";
    private static final String ID_TABLE_SEARCH_CLEAR = "table-search-clear";
    private final DataTableWithPagesAndFilter<?, ?> table;

    public FilterToolbar(String id, DataTableWithPagesAndFilter<?, ?> table) {
        super(id);
        this.table = table;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui();
        this.setVisible(this.table.elementCount() > 1);
    }

    private void buildGui() {
        DataTableInteractive tableModel = this.table.tableModel();
        TextField searchField = new TextField(ID_TABLE_SEARCH_INPUT, (IModel)Model.of((Serializable)((Object)((String)tableModel.searchArgumentBindable().getValue()))));
        Wkt.attributeReplace(searchField, "placeholder", tableModel.getSearchPromptPlaceholderText());
        Wkt.linkAdd((MarkupContainer)this, ID_TABLE_SEARCH_BUTTON, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> this.propagateUpdate((AjaxRequestTarget)target, searchField.getValue()));
        Wkt.linkAdd((MarkupContainer)this, ID_TABLE_SEARCH_CLEAR, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
            searchField.setModelObject(null);
            target.add(new Component[]{searchField});
            this.propagateUpdate((AjaxRequestTarget)target, searchField.getValue());
        });
        searchField.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.addOrReplace(new Component[]{searchField});
    }

    private void propagateUpdate(AjaxRequestTarget target, String searchArg) {
        this.table.setSearchArg(searchArg);
        this.table.setSearchHintAndBroadcast(target);
        target.add(new Component[]{this.table});
    }

    @Generated
    public DataTableWithPagesAndFilter<?, ?> getTable() {
        return this.table;
    }
}

