/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.head;

import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.head.HeadersToolbarAbstract;
import org.apache.causeway.viewer.wicket.ui.components.table.head.OrderByBorder;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class HeadersToolbar
extends HeadersToolbarAbstract<String> {
    private static final long serialVersionUID = 1L;
    private final CollectionContentsSortableDataProvider singleSortStateLocator;
    private DataTableWithPagesAndFilter<?, String> table;

    public HeadersToolbar(DataTableWithPagesAndFilter<?, String> table, CollectionContentsSortableDataProvider singleSortStateLocator, CausewayConfiguration.Viewer.Wicket wicketConfig) {
        super(table, (ISortStateLocator)_Casts.uncheckedCast((Object)((Object)singleSortStateLocator)), wicketConfig);
        this.table = table;
        this.singleSortStateLocator = singleSortStateLocator;
        Wkt.ajaxEnable(table);
    }

    @Override
    protected WebMarkupContainer newSortableHeader(String borderId, String property, ISortStateLocator<String> locator) {
        return new OrderByBorder<String>(borderId, this.table, property, locator);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.honorSortOrderHints();
    }

    private void honorSortOrderHints() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder sortOrder : SortOrder.values()) {
            String property = uiHintContainer.getHint(this.table, sortOrder.name());
            if (property == null) continue;
            this.singleSortStateLocator.getSortState().setPropertySortOrder((Object)property, sortOrder);
        }
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, UiObjectWkt.class);
    }
}

