/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.nav;

import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.model.timetaken.TimeTakenModel;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.nav.pagesize.PagesizeChooser;
import org.apache.causeway.viewer.wicket.ui.components.table.nav.paging.PageNavigator;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.IModel;

public class NavigationToolbar
extends AjaxNavigationToolbar
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private static final String NAVIGATOR_CONTAINER_ID = "span";
    private static final String ID_PAGESIZE_CHOOSER = "pagesizeChooser";

    public NavigationToolbar(DataTableWithPagesAndFilter<?, ?> table) {
        super(table);
        this.buildGui();
    }

    protected PagingNavigator newPagingNavigator(String navigatorId, DataTable<?, ?> table) {
        return new PageNavigator(navigatorId, (IPageable)table);
    }

    protected DataTableWithPagesAndFilter<?, ?> getTable() {
        return (DataTableWithPagesAndFilter)super.getTable();
    }

    private void buildGui() {
        MarkupContainer navigatorContainer = this.navigatorContainer();
        Wkt.add(navigatorContainer, new PagesizeChooser(ID_PAGESIZE_CHOOSER, (DataTableWithPagesAndFilter<?, ?>)this.getTable()));
        Wkt.labelAdd(navigatorContainer, "prototypingLabel", (IModel<String>)TimeTakenModel.createForPrototypingElseBlank((MetaModelContext)this.getMetaModelContext()));
    }

    private MarkupContainer navigatorContainer() {
        return (MarkupContainer)this.get(NAVIGATOR_CONTAINER_ID);
    }
}

