/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.unknown;

import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

class UnknownModelPanel
extends PanelAbstract<Object, IModel<Object>> {
    private static final long serialVersionUID = 1L;

    public UnknownModelPanel(String id, IModel<?> model) {
        super(id, (IModel)_Casts.uncheckedCast(model));
        this.buildGui(id);
    }

    private void buildGui(String id) {
        Wkt.labelAdd((MarkupContainer)this, "unknown", this.buildMessage());
    }

    private String buildMessage() {
        StringBuilder buf = new StringBuilder();
        if (this.getModel() != null) {
            this.buildMessageForModel(buf, (IModel<?>)this.getModel());
        } else {
            buf.append("??? model is NULL");
        }
        return buf.toString();
    }

    private void buildMessageForModel(StringBuilder buf, IModel<?> model) {
        buf.append(model.getClass().getSimpleName()).append(" ");
        if (model instanceof UiObjectWkt) {
            UiObjectWkt objectModel = (UiObjectWkt)model;
            ManagedObject objectAdapter = (ManagedObject)objectModel.getObject();
            if (objectAdapter != null) {
                buf.append("??? objectAdapter oid: " + String.valueOf(ManagedObjects.bookmark((ManagedObject)objectAdapter).orElse(null)));
            } else {
                buf.append("??? objectAdapter is NULL");
            }
        } else if (model instanceof UiAttributeWkt) {
            UiAttributeWkt attributeModel = (UiAttributeWkt)model;
            ManagedObject attributeAdapter = attributeModel.getObject();
            if (ManagedObjects.isSpecified((ManagedObject)attributeAdapter)) {
                buf.append(String.format("??? spec=%s, value='%s'", attributeAdapter.getSpecification(), attributeAdapter.getPojo()));
            } else {
                buf.append("??? scalarAdapter is NULL or UNSPECIFIED");
            }
        }
    }
}

