/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.obj;

import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.modelhelpers.WhereAmIHelper;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.components.object.icontitle.ObjectIconAndTitlePanelFactory;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class DomainObjectPage
extends PageAbstract {
    private static final long serialVersionUID = 144368606134796079L;
    private static final String ID_DOMAIN_OBJECT_CONTAINER = "domainObjectContainer";
    private static final String ID_DOMAIN_OBJECT = UiComponentType.DOMAIN_OBJECT.getId();
    private static final String ID_WHEREAMI_CONTAINER = "whereAmI-container";
    private static final String ID_WHEREAMI_ITEMS = "whereAmI-items";
    private static final CssResourceReference DOMAIN_OBJECT_PAGE_CSS = new CssResourceReference(DomainObjectPage.class, "DomainObjectPage.css");
    private final UiObjectWkt model;

    public static DomainObjectPage forPageParameters(PageParameters pageParameters) {
        Optional bookmark = PageParameterUtils.toBookmark((PageParameters)pageParameters);
        if (!bookmark.isPresent()) {
            throw new RestartResponseException(Application.get().getHomePage());
        }
        return new DomainObjectPage(pageParameters, UiObjectWkt.ofPageParameters((PageParameters)pageParameters));
    }

    public static DomainObjectPage forAdapter(ManagedObject adapter) {
        return new DomainObjectPage(PageParameterUtils.createPageParametersForObject((ManagedObject)adapter), UiObjectWkt.ofAdapter((ManagedObject)adapter));
    }

    private DomainObjectPage(PageParameters pageParameters, UiObjectWkt objectModel) {
        super(pageParameters, null, UiComponentType.DOMAIN_OBJECT);
        this.model = objectModel;
    }

    protected void onInitialize() {
        this.buildPage();
        super.onInitialize();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)DOMAIN_OBJECT_PAGE_CSS));
    }

    @Override
    public UiHintContainer getUiHintContainerIfAny() {
        return this.model;
    }

    private void buildPage() {
        ManagedObject objectAdapter;
        try {
            objectAdapter = (ManagedObject)this.model.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw new ObjectMember.AuthorizationException(ex);
        }
        if (!this.model.isVisible()) {
            throw new ObjectMember.AuthorizationException();
        }
        ObjectSpecification objectSpec = this.model.getTypeOfSpecification();
        Facets.gridPreload((ObjectSpecification)objectSpec, (ManagedObject)objectAdapter);
        String titleStr = objectAdapter.getTitle();
        this.setTitle(titleStr);
        WebMarkupContainer domainObjectContainer = new WebMarkupContainer(ID_DOMAIN_OBJECT_CONTAINER);
        Wkt.cssAppend(domainObjectContainer, objectSpec.getFeatureIdentifier());
        Facets.cssClass((FacetHolder)objectSpec, (ManagedObject)objectAdapter).ifPresent(cssClass -> Wkt.cssAppend(domainObjectContainer, cssClass));
        this.themeDiv.addOrReplace(new Component[]{domainObjectContainer});
        this.addWhereAmIIfShown(domainObjectContainer, WhereAmIHelper.of((UiObjectWkt)this.model));
        this.bookmarkPageIfShown((BookmarkableModel)this.model);
        this.addBreadcrumbIfShown(this.model);
        this.addBookmarkedPages((MarkupContainer)domainObjectContainer);
        Try.run(() -> this.addChildComponents((MarkupContainer)domainObjectContainer, (IModel<?>)this.model)).ifFailure(__ -> Wkt.add((MarkupContainer)domainObjectContainer, new EmptyPanel(ID_DOMAIN_OBJECT))).ifFailureFail();
    }

    protected void addWhereAmIIfShown(WebMarkupContainer domainObjectContainer, WhereAmIHelper whereAmIModel) {
        WebMarkupContainer whereAmIContainer = new WebMarkupContainer(ID_WHEREAMI_CONTAINER);
        domainObjectContainer.addOrReplace(new Component[]{whereAmIContainer});
        if (!whereAmIModel.isShowWhereAmI()) {
            whereAmIContainer.setVisible(false);
            return;
        }
        RepeatingView listItems = new RepeatingView(ID_WHEREAMI_ITEMS);
        whereAmIModel.streamParentChainReversed().forEach(objectModel -> listItems.add(new Component[]{ObjectIconAndTitlePanelFactory.entityIconAndTitlePanel(listItems.newChildId(), (ObjectAdapterModel)objectModel)}));
        Wkt.labelAdd((MarkupContainer)listItems, listItems.newChildId(), whereAmIModel.getStartOfChain().getTitle());
        whereAmIContainer.addOrReplace(new Component[]{listItems});
    }

    @Override
    public void onNewRequestCycle() {
        UiObjectWkt objectModel = (UiObjectWkt)this.getUiHintContainerIfAny();
        ManagedObjects.refreshViewmodel((ManagedObject)((ManagedObject)objectModel.getObject()), () -> (Bookmark)PageParameterUtils.toBookmark((PageParameters)this.getPageParameters()).orElseThrow());
    }

    @Override
    public void onRendering(Can<PageRenderSubscriber> pageRenderSubscribers) {
        this.onRenderingOrRendered(pageRenderSubscribers, (pageRenderSubscriber, bookmark) -> {
            pageRenderSubscriber.onRenderingDomainObject(bookmark);
            return null;
        });
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> pageRenderSubscribers) {
        this.onRenderingOrRendered(pageRenderSubscribers, (pageRenderSubscriber, bookmark) -> {
            pageRenderSubscriber.onRenderedDomainObject(bookmark);
            return null;
        });
    }

    private void onRenderingOrRendered(Can<PageRenderSubscriber> pageRenderSubscribers, BiFunction<PageRenderSubscriber, Bookmark, Void> handler) {
        if (pageRenderSubscribers.isEmpty()) {
            return;
        }
        ManagedObjects.asSpecified((ManagedObject)((ManagedObject)this.model.getObject())).map(Bookmarkable::getBookmark).filter(Optional::isPresent).map(Optional::get).ifPresent(bookmark -> pageRenderSubscribers.forEach(pageRenderSubscriber -> handler.apply((PageRenderSubscriber)pageRenderSubscriber, (Bookmark)bookmark)));
    }

    private void addBreadcrumbIfShown(UiObjectWkt objectModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.visited(objectModel));
    }

    private void removeAnyBreadcrumb(UiObjectWkt objectModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.remove(objectModel));
    }
}

