/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actions;

import java.io.Serializable;
import lombok.Generated;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

class ActionParametersPanel
extends PanelAbstract<ManagedObject, ActionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_ACTION_NAME = "actionName";
    private final boolean showHeader;

    public ActionParametersPanel(String id, ActionModel actionModel, boolean showHeader) {
        super(id, actionModel);
        this.showHeader = showHeader;
    }

    ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    protected void onInitialize() {
        super.onInitialize();
        ActionModel actionModel = (ActionModel)this.getModel();
        if (!actionModel.hasParameters()) {
            throw new IllegalStateException("model has no parameters!");
        }
        WebMarkupContainer header = Wkt.containerWithVisibility(ID_HEADER, this::isShowHeader);
        this.addOrReplace(new Component[]{header});
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.PARAMETERS, (IModel<?>)actionModel);
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, UiComponentType.OBJECT_ICON_AND_TITLE, (IModel<?>)actionModel.getParentUiModel());
        Wkt.labelAdd((MarkupContainer)header, ID_ACTION_NAME, (IModel<String>)(IModel & Serializable)() -> this.getActionModel().getFriendlyName());
    }

    @Generated
    public boolean isShowHeader() {
        return this.showHeader;
    }
}

