/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.image;

import java.awt.image.BufferedImage;
import java.util.Optional;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.core.metamodel.valuesemantics.ImageValueSemantics;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

class ImagePanel
extends PanelAbstract<ManagedObject, UiAttributeWkt> {
    private static final long serialVersionUID = 1L;
    private static final String ID_THUMBNAIL = "thumbnail";
    private static final String ID_IMAGELINK = "imagelink";
    private static final CssResourceReference IMAGE_CSS = new CssResourceReference(ImagePanel.class, "ImagePanel.css");

    public ImagePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)IMAGE_CSS));
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui();
    }

    private void buildGui() {
        this.bufferedImage().ifPresentOrElse(bufferedImage -> {
            this.addOrReplace(new Component[]{Wkt.imageNonCaching(ID_THUMBNAIL, bufferedImage)});
            this.addOrReplace(new Component[]{Wkt.link(ID_IMAGELINK, bufferedImage)});
        }, () -> WktComponents.permanentlyHide((MarkupContainer)this, ID_THUMBNAIL, ID_IMAGELINK));
    }

    private final UiAttributeWkt attributeModel() {
        return (UiAttributeWkt)this.getModel();
    }

    private Optional<BufferedImage> bufferedImage() {
        UiAttributeWkt model = this.attributeModel();
        ManagedObject adapter = model.getObject();
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            return Optional.empty();
        }
        ObjectSpecification typeSpec = model.getElementType();
        return Facets.valueStreamSemantics((ObjectSpecification)typeSpec, ImageValueSemantics.class).map(imageValueSemantics -> imageValueSemantics.getImage(adapter).orElse(null)).filter(_NullSafe::isPresent).findFirst();
    }
}

