/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.summary;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Predicate;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.summary.CollectionContentsAsSummary;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;

public class CollectionContentsAsSummaryFactory
extends ComponentFactoryAbstract
implements CollectionContentsAsFactory {
    private static final String NAME = "summary";
    static final Predicate<ObjectAssociation> OF_TYPE_BIGDECIMAL = objectAssoc -> {
        ObjectSpecification objectSpec = objectAssoc.getElementType();
        return objectSpec.isValue() && objectSpec.getCorrespondingClass().equals(BigDecimal.class);
    };

    public CollectionContentsAsSummaryFactory() {
        super(UiComponentType.COLLECTION_CONTENTS, NAME, CollectionContentsAsSummary.class);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        boolean hasAnyBigDecProperty = _Casts.castTo(CollectionModel.class, model).map(CollectionModel::getElementType).map(elementSpec -> elementSpec.streamAssociations(MixedIn.EXCLUDED).anyMatch(OF_TYPE_BIGDECIMAL)).orElse(false);
        return this.appliesIf(hasAnyBigDecProperty);
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        _Assert.assertNullableObjectIsInstanceOf(model, CollectionModel.class);
        CollectionModel collectionModel = (CollectionModel)model;
        return new CollectionContentsAsSummary(id, collectionModel);
    }

    @Override
    public CssResourceReference getCssResourceReference() {
        return null;
    }

    @Override
    public IModel<String> getTitleLabel() {
        return new ResourceModel("CollectionContentsAsSummaryFactory.Summary", "Summary");
    }

    @Override
    public IModel<String> getCssClass() {
        return Model.of((Serializable)((Object)"fa fa-fw fa-usd"));
    }

    @Override
    public int orderOfAppearanceInUiDropdown() {
        return 1700;
    }
}

