/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.exec;

import java.net.URL;
import lombok.Generated;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.applib.value.OpenUrlStrategy;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.PackedManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionResultModel;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.models.RedirectRequestHandlerWithOpenUrlStrategy;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.VoidModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelStandalone;
import org.apache.causeway.viewer.wicket.ui.exec.DownloadHandlerFactory;
import org.apache.causeway.viewer.wicket.ui.exec.Mediator;
import org.apache.causeway.viewer.wicket.ui.exec.PageRedirectRequest;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.causeway.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.causeway.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class MediatorFactory {
    static Mediator determineAndInterpretResult(@NonNull ActionModel actionModel, @Nullable AjaxRequestTarget ajaxTarget, @Nullable ManagedObject resultAdapterIfAny) {
        Mediator mediator;
        ActionResultModel actionResultModel = ActionResultModel.determineFor((ActionModel)actionModel, (ManagedObject)resultAdapterIfAny, (AjaxRequestTarget)ajaxTarget);
        Mediator response = MediatorFactory.actionResultResponse(actionModel, ajaxTarget, actionResultModel);
        if (response.pageRedirect() != null) {
            switch (actionModel.columnActionModifier()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    mediator = response;
                    break;
                }
                case FORCE_STAY_ON_PAGE: {
                    mediator = new Mediator(Mediator.ExecutionResultHandlingStrategy.OPEN_URL_IN_SAME_BROWSER_WINDOW, null, null, ajaxTarget, response.pageRedirect().toUrl());
                    break;
                }
                case FORCE_NEW_BROWSER_WINDOW: {
                    mediator = new Mediator(Mediator.ExecutionResultHandlingStrategy.OPEN_URL_IN_NEW_BROWSER_WINDOW, null, null, ajaxTarget, response.pageRedirect().toUrl());
                    break;
                }
            }
        } else {
            mediator = response;
        }
        return mediator;
    }

    private static IRequestHandler redirectHandler(Object value, @NonNull OpenUrlStrategy openUrlStrategy, @NonNull WebAppContextPath webAppContextPath) {
        if (value instanceof URL) {
            URL url = (URL)value;
            return new RedirectRequestHandlerWithOpenUrlStrategy(url.toString());
        }
        if (value instanceof LocalResourcePath) {
            LocalResourcePath localResourcePath = (LocalResourcePath)value;
            return new RedirectRequestHandlerWithOpenUrlStrategy(localResourcePath.getEffectivePath(arg_0 -> ((WebAppContextPath)webAppContextPath).prependContextPath(arg_0)), localResourcePath.openUrlStrategy());
        }
        return null;
    }

    private static Mediator actionResultResponse(@NonNull ActionModel actionModel, @Nullable AjaxRequestTarget ajaxTarget, @NonNull ActionResultModel actionResultModel) {
        FormExecutor.ActionResultResponseType responseType = actionResultModel.responseType();
        ManagedObject resultAdapter = actionResultModel.resultAdapter();
        switch (responseType) {
            case COLLECTION: {
                _Assert.assertTrue((boolean)(resultAdapter instanceof PackedManagedObject));
                CollectionModelStandalone collectionModel = CollectionModelStandalone.forActionModel((PackedManagedObject)((PackedManagedObject)resultAdapter), (ActionModel)actionModel);
                PageRedirectRequest<StandaloneCollectionPage> pageRedirectRequest = PageRedirectRequest.forPage(StandaloneCollectionPage.class, new StandaloneCollectionPage(collectionModel));
                return Mediator.toPage(pageRedirectRequest);
            }
            case OBJECT: {
                MediatorFactory.determineScalarAdapter(actionModel.getMetaModelContext(), resultAdapter);
                return Mediator.toDomainObjectPage(resultAdapter);
            }
            case SIGN_IN: {
                Class<? extends Page> signInPage = ((PageClassRegistry)actionModel.getMetaModelContext().lookupServiceElseFail(PageClassRegistry.class)).getPageClass(PageType.SIGN_IN);
                PageRedirectRequest<? extends Page> pageRedirectRequest = PageRedirectRequest.forPageClass(signInPage);
                return Mediator.toPage(pageRedirectRequest);
            }
            case VALUE: {
                ValueModel valueModel = new ValueModel(actionModel, resultAdapter);
                ValuePage valuePage = new ValuePage(valueModel, actionModel.getFriendlyName());
                PageRedirectRequest<ValuePage> pageRedirectRequest = PageRedirectRequest.forPage(ValuePage.class, valuePage);
                return Mediator.toPage(pageRedirectRequest);
            }
            case VALUE_BLOB: {
                Object value = resultAdapter.getPojo();
                IRequestHandler handler = DownloadHandlerFactory.downloadHandler(actionModel.getAction(), value);
                return Mediator.withHandler(handler);
            }
            case VALUE_CLOB: {
                Object value = resultAdapter.getPojo();
                IRequestHandler handler = DownloadHandlerFactory.downloadHandler(actionModel.getAction(), value);
                return Mediator.withHandler(handler);
            }
            case VALUE_LOCALRESPATH_AJAX: {
                LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                return Mediator.openUrlInBrowser(ajaxTarget, localResPath.getEffectivePath(arg_0 -> ((WebAppContextPath)webAppContextPath).prependContextPath(arg_0)), localResPath.openUrlStrategy());
            }
            case VALUE_LOCALRESPATH_NOAJAX: {
                LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                IRequestHandler handler = MediatorFactory.redirectHandler(localResPath, localResPath.openUrlStrategy(), webAppContextPath);
                return Mediator.withHandler(handler);
            }
            case VALUE_URL_AJAX: {
                URL url = (URL)resultAdapter.getPojo();
                return Mediator.openUrlInBrowser(ajaxTarget, url.toString(), OpenUrlStrategy.NEW_WINDOW);
            }
            case VALUE_URL_NOAJAX: {
                Object value = resultAdapter.getPojo();
                WebAppContextPath webAppContextPath = actionModel.getMetaModelContext().getWebAppContextPath();
                IRequestHandler handler = MediatorFactory.redirectHandler(value, OpenUrlStrategy.NEW_WINDOW, webAppContextPath);
                return Mediator.withHandler(handler);
            }
            case VOID_AS_EMPTY: {
                PageRedirectRequest<VoidReturnPage> pageRedirectRequest = PageRedirectRequest.forPage(VoidReturnPage.class, new VoidReturnPage(new VoidModel(), actionModel.getFriendlyName()));
                return Mediator.toPage(pageRedirectRequest);
            }
            case RELOAD: {
                IRequestablePage currentPage = PageRequestHandlerTracker.getLastHandler((RequestCycle)RequestCycle.get()).getPage();
                Class pageClass = currentPage.getClass();
                PageRedirectRequest<IRequestablePage> pageRedirectRequest = PageRedirectRequest.forPage(pageClass, (IRequestablePage)_Casts.uncheckedCast((Object)currentPage));
                return Mediator.toPage(pageRedirectRequest);
            }
        }
        throw _Exceptions.unmatchedCase((Object)responseType);
    }

    private static ManagedObject determineScalarAdapter(@NonNull MetaModelContext mmc, @NonNull ManagedObject resultAdapter) {
        if (resultAdapter.objSpec().isSingular()) {
            return resultAdapter;
        }
        Object pojo = _NullSafe.streamAutodetect((Object)resultAdapter.getPojo()).findFirst().orElseThrow(_Exceptions::noSuchElement);
        ManagedObject scalarAdapter = mmc.getObjectManager().adapt(pojo);
        return scalarAdapter;
    }

    @Generated
    private MediatorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

