/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.decorators.ActionDecorators;
import org.apache.causeway.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.causeway.viewer.commons.model.decorators.DangerDecorator;
import org.apache.causeway.viewer.commons.model.decorators.DisablingDecorator;
import org.apache.causeway.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.causeway.viewer.commons.model.decorators.IconDecorator;
import org.apache.causeway.viewer.commons.model.decorators.PrototypingDecorator;
import org.apache.causeway.viewer.commons.model.decorators.TooltipDecorator;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.FontAwesomeBehavior;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.BootstrapConstants;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableBiFunction;

public final class WktDecorators {
    private static final AtomicReference<Object> formLabel = new AtomicReference();
    private static final AtomicReference<Object> tooltip = new AtomicReference();
    private static final AtomicReference<Object> disable = new AtomicReference();
    private static final AtomicReference<Object> prototyping = new AtomicReference();
    private static final AtomicReference<Object> confirm = new AtomicReference();
    private static final AtomicReference<Object> danger = new AtomicReference();
    private static final AtomicReference<Object> faIcon = new AtomicReference();
    private static final AtomicReference<Object> missingIcon = new AtomicReference();

    public static void decorateMenuAction(AjaxLink<ManagedObject> actionLink, Component tooltipReceiver, Label actionLabel, ActionDecorators.ActionDecorationModel decorationModel) {
        decorationModel.disabling().ifPresentOrElse(disableUiModel -> {
            WktDecorators.disable().decorate(tooltipReceiver, (DisablingDecorator.DisablingDecorationModel)disableUiModel);
            WktDecorators.tooltip().decorate(tooltipReceiver, TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)disableUiModel.reason()));
        }, () -> {
            decorationModel.describedAs().ifPresent(describedAs -> WktDecorators.tooltip().decorate(tooltipReceiver, TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)describedAs)));
            if (decorationModel.isImmediateConfirmationRequired()) {
                ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((UiPlacementDirection)UiPlacementDirection.BOTTOM);
                WktDecorators.confirm().decorate((Component)actionLink, confirmUiModel);
            }
        });
        Wkt.cssAppend(tooltipReceiver, decorationModel.featureIdentifier());
        WktDecorators.decorateActionCommon(actionLink, actionLabel, decorationModel);
    }

    public static void decorateActionLink(AjaxLink<ManagedObject> actionLink, Component tooltipReceiver, Label actionLabel, ActionDecorators.ActionDecorationModel decorationModel) {
        ObjectAction action = decorationModel.action();
        WktTooltips.addTooltip(tooltipReceiver, decorationModel.disabling().isPresent() ? ((ActionLink)actionLink).getReasonDisabledIfAny() : (String)decorationModel.describedAs().orElse(null));
        if (action.getSemantics().isAreYouSure()) {
            if (action.getParameterCount() == 0 && decorationModel.disabling().isEmpty()) {
                ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((UiPlacementDirection)UiPlacementDirection.BOTTOM);
                WktDecorators.confirm().decorate((Component)actionLink, confirmUiModel);
            }
            WktDecorators.danger().decorate((Component)actionLink);
        } else {
            Wkt.cssAppend(actionLink, decorationModel.isLowerVisualRank() ? BootstrapConstants.ButtonSemantics.SECONDARY.buttonOutlineCss() : BootstrapConstants.ButtonSemantics.SECONDARY.buttonDefaultCss());
        }
        WktDecorators.decorateActionCommon(actionLink, actionLabel, decorationModel);
    }

    public static void decorateCssMenuItem(AjaxLink<ManagedObject> actionLink, Label actionLabel, ActionDecorators.ActionDecorationModel decorationModel) {
        decorationModel.disabling().ifPresentOrElse(disableUiModel -> WktDecorators.disable().decorate((Component)actionLink, (DisablingDecorator.DisablingDecorationModel)disableUiModel), () -> decorationModel.describedAs().ifPresent(describedAs -> WktTooltips.addTooltip(actionLink, describedAs)));
        WktDecorators.decorateActionCommon(actionLink, actionLabel, decorationModel);
    }

    private static void decorateActionCommon(AjaxLink<ManagedObject> actionLink, Label actionLabel, ActionDecorators.ActionDecorationModel decorationModel) {
        CausewayConfiguration.Viewer.Wicket wicketConfig;
        if (decorationModel.isBoundToDialog() && (wicketConfig = MetaModelContext.instanceElseFail().getConfiguration().getViewer().getWicket()).isActionIndicationWhenBoundToDialog()) {
            IModel ellipsifiedModel = actionLabel.getDefaultModel().combineWith((IModel)Model.of((Serializable)((Object)"\u2026")), (SerializableBiFunction & Serializable)(a, b) -> String.valueOf(a) + b);
            actionLabel.setDefaultModel(ellipsifiedModel);
        }
        Wkt.cssAppend(actionLink, decorationModel.featureIdentifier());
        decorationModel.additionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(actionLink, cssClass));
        if (ObjectAction.Util.returnsBlobOrClob((ObjectAction)decorationModel.action())) {
            Wkt.cssAppend(actionLink, "noVeil");
        }
        decorationModel.prototyping().ifPresent(protoDecModel -> WktDecorators.prototyping().decorate((Component)actionLink, (PrototypingDecorator.PrototypingDecorationModel)protoDecModel));
        Optional faLayers = decorationModel.fontAwesomeLayers();
        WktDecorators.faIcon().decorate((Component)actionLabel, (Optional<FontAwesomeLayers>)faLayers);
        if (decorationModel.isMenuItem()) {
            WktDecorators.missingIcon().decorate((Component)actionLink, (Optional<FontAwesomeLayers>)faLayers);
        }
    }

    @Generated
    private WktDecorators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FormLabel formLabel() {
        Object $value = formLabel.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = formLabel;
            synchronized (atomicReference) {
                $value = formLabel.get();
                if ($value == null) {
                    FormLabel actualValue = new FormLabel();
                    $value = actualValue == null ? formLabel : actualValue;
                    formLabel.set($value);
                }
            }
        }
        return (FormLabel)($value == formLabel ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Tooltip tooltip() {
        Object $value = tooltip.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = tooltip;
            synchronized (atomicReference) {
                $value = tooltip.get();
                if ($value == null) {
                    Tooltip actualValue = new Tooltip();
                    $value = actualValue == null ? tooltip : actualValue;
                    tooltip.set($value);
                }
            }
        }
        return (Tooltip)($value == tooltip ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Disable disable() {
        Object $value = disable.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = disable;
            synchronized (atomicReference) {
                $value = disable.get();
                if ($value == null) {
                    Disable actualValue = new Disable();
                    $value = actualValue == null ? disable : actualValue;
                    disable.set($value);
                }
            }
        }
        return (Disable)($value == disable ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Prototyping prototyping() {
        Object $value = prototyping.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = prototyping;
            synchronized (atomicReference) {
                $value = prototyping.get();
                if ($value == null) {
                    Prototyping actualValue = new Prototyping();
                    $value = actualValue == null ? prototyping : actualValue;
                    prototyping.set($value);
                }
            }
        }
        return (Prototyping)($value == prototyping ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Confirm confirm() {
        Object $value = confirm.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = confirm;
            synchronized (atomicReference) {
                $value = confirm.get();
                if ($value == null) {
                    Confirm actualValue = new Confirm();
                    $value = actualValue == null ? confirm : actualValue;
                    confirm.set($value);
                }
            }
        }
        return (Confirm)($value == confirm ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Danger danger() {
        Object $value = danger.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = danger;
            synchronized (atomicReference) {
                $value = danger.get();
                if ($value == null) {
                    Danger actualValue = new Danger();
                    $value = actualValue == null ? danger : actualValue;
                    danger.set($value);
                }
            }
        }
        return (Danger)($value == danger ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FaIcon faIcon() {
        Object $value = faIcon.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = faIcon;
            synchronized (atomicReference) {
                $value = faIcon.get();
                if ($value == null) {
                    FaIcon actualValue = new FaIcon();
                    $value = actualValue == null ? faIcon : actualValue;
                    faIcon.set($value);
                }
            }
        }
        return (FaIcon)($value == faIcon ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static MissingIcon missingIcon() {
        Object $value = missingIcon.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = missingIcon;
            synchronized (atomicReference) {
                $value = missingIcon.get();
                if ($value == null) {
                    MissingIcon actualValue = new MissingIcon();
                    $value = actualValue == null ? missingIcon : actualValue;
                    missingIcon.set($value);
                }
            }
        }
        return (MissingIcon)($value == missingIcon ? null : $value);
    }

    public record Confirm() implements ConfirmDecorator<Component>
    {
        public void decorate(Component uiComponent, ConfirmDecorator.ConfirmDecorationModel decorationModel) {
            ConfirmationConfig confirmationConfig = new ConfirmationConfig().withTitle(decorationModel.title()).withBtnOkLabel(decorationModel.okLabel()).withBtnCancelLabel(decorationModel.cancelLabel()).withBtnOkClass(BootstrapConstants.ButtonSemantics.DANGER.fullButtonCss()).withBtnCancelClass(BootstrapConstants.ButtonSemantics.SECONDARY.fullButtonCss()).withPlacement(TooltipConfig.Placement.valueOf((String)decorationModel.placement().name().toLowerCase()));
            Wkt.behaviorAddConfirm(uiComponent, confirmationConfig);
            if (uiComponent instanceof Button) {
                WktDecorators.danger().decorate(uiComponent);
            }
        }
    }

    public record Danger() implements DangerDecorator<Component>
    {
        public void decorate(Component uiComponent) {
            Wkt.cssAppend(uiComponent, BootstrapConstants.ButtonSemantics.DANGER.buttonDefaultCss());
        }
    }

    public record FaIcon() implements IconDecorator<Component, Component>
    {
        public Component decorate(Component uiComponent, Optional<FontAwesomeLayers> faLayers) {
            if (faLayers.isPresent()) {
                uiComponent.add(new Behavior[]{new FontAwesomeBehavior(faLayers.get())});
            }
            return uiComponent;
        }
    }

    public record MissingIcon() implements IconDecorator<Component, Component>
    {
        public Component decorate(Component uiComponent, Optional<FontAwesomeLayers> faLayers) {
            if (faLayers.isEmpty()) {
                Wkt.cssAppend(uiComponent, "menuLinkSpacer");
            }
            return uiComponent;
        }
    }

    public record FormLabel() implements FormLabelDecorator<Component>
    {
        public void decorate(Component uiComponent, FormLabelDecorator.FormLabelDecorationModel decorationModel) {
            if (decorationModel.isMandatoryIndicatorShown()) {
                Wkt.cssAppend(uiComponent, "mandatory");
            }
            uiComponent.setEscapeModelStrings(true);
        }
    }

    public record Tooltip() implements TooltipDecorator<Component>
    {
        public void decorate(Component uiComponent, TooltipDecorator.TooltipDecorationModel decorationModel) {
            WktTooltips.addTooltip(uiComponent, decorationModel);
        }
    }

    public record Disable() implements DisablingDecorator<Component>
    {
        public void decorate(Component uiComponent, DisablingDecorator.DisablingDecorationModel decorationModel) {
            TooltipDecorator.TooltipDecorationModel tooltipDecorationModel = TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)UiPlacementDirection.BOTTOM, (String)decorationModel.reason());
            WktDecorators.tooltip().decorate(uiComponent, tooltipDecorationModel);
            Wkt.cssAppend(uiComponent, "disabled");
            uiComponent.setEnabled(false);
        }
    }

    public record Prototyping() implements PrototypingDecorator<Component, Component>
    {
        public Component decorate(Component uiComponent, PrototypingDecorator.PrototypingDecorationModel decorationModel) {
            Wkt.cssAppend(uiComponent, "prototype");
            return uiComponent;
        }
    }
}

