/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithInlinePrompt;
import org.apache.causeway.viewer.wicket.ui.components.attributes._Util;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.AttributePanelWithSelect;
import org.apache.causeway.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.causeway.viewer.wicket.ui.util.XrayWkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jspecify.annotations.Nullable;

public abstract class AttributePanelWithFormField<T>
extends AttributePanelWithInlinePrompt {
    private static final long serialVersionUID = 1L;
    protected final Class<T> type;
    private FormComponent<T> formComponent;

    protected AttributePanelWithFormField(String id, UiAttributeWkt attributeModel, Class<T> type) {
        super(id, attributeModel);
        this.type = type;
    }

    @Override
    protected final Component getValidationFeedbackReceiver() {
        return this.getFormComponent();
    }

    protected MarkupContainer createFieldFrame() {
        AttributePanel.RenderScenario renderScenario = this.getRenderScenario();
        AttributeFragmentFactory.FieldFragment fieldFragment = switch (renderScenario) {
            case AttributePanel.RenderScenario.READONLY -> AttributeFragmentFactory.FieldFragment.NO_LINK_VIEWING;
            case AttributePanel.RenderScenario.CAN_EDIT, AttributePanel.RenderScenario.CAN_EDIT_INLINE, AttributePanel.RenderScenario.CAN_EDIT_INLINE_VIA_ACTION, AttributePanel.RenderScenario.EDITING_WITH_LINK_TO_NESTED -> AttributeFragmentFactory.FieldFragment.LINK_TO_PROMT;
            case AttributePanel.RenderScenario.EDITING -> this.attributeModel().isEditingMode() ? AttributeFragmentFactory.FieldFragment.NO_LINK_EDITING : AttributeFragmentFactory.FieldFragment.NO_LINK_VIEWING;
            default -> throw _Exceptions.unmatchedCase((Object)((Object)renderScenario));
        };
        return Wkt.fragment(fieldFragment.getContainerId(), fieldFragment.getFragmentId(), (MarkupContainer)this);
    }

    protected final @Nullable FormComponent<T> getFormComponent() {
        return this.formComponent;
    }

    protected abstract FormComponent<T> createFormComponent(String var1, UiAttributeWkt var2);

    @Override
    protected final MarkupContainer createRegularFrame() {
        UiAttributeWkt attributeModel = this.attributeModel();
        Model friendlyNameModel = Model.of((Serializable)((Object)attributeModel.getFriendlyName()));
        this.formComponent = this.createFormComponent("scalarValue", attributeModel);
        this.formComponent.setLabel((IModel)friendlyNameModel);
        FormGroup formGroup = AttributeFragmentFactory.FrameFragment.REGULAR.createComponent(id -> new FormGroup((String)id, this.formComponent));
        formGroup.add(new Component[]{this.formComponent});
        Component[] componentArray = new Component[1];
        this.fieldFrame = this.createFieldFrame();
        componentArray[0] = this.fieldFrame;
        formGroup.add(componentArray);
        this.formComponent.setRequired(attributeModel.isRequired());
        if (attributeModel.isShowMandatoryIndicator()) {
            Wkt.cssAppend(formGroup, "mandatory");
        }
        this.scalarNameLabelAddTo((MarkupContainer)formGroup, (IModel<String>)friendlyNameModel);
        this.formComponent.add(_Util.createValidatorFor(attributeModel));
        AttributePanel.RenderScenario renderScenario = this.getRenderScenario();
        XrayWkt.ifEnabledDo(() -> {
            LinkedHashMap xrayDetails = _Maps.newLinkedHashMap();
            xrayDetails.put("panel", this.getClass().getSimpleName());
            xrayDetails.put("renderScenario", renderScenario.name());
            xrayDetails.put("inputFragmentType", this.getInputFragmentType().map(x -> x.name()).orElse("(none)"));
            xrayDetails.put("formComponent", _Strings.nonEmpty((CharSequence)this.formComponent.getClass().getSimpleName()).orElseGet(() -> this.formComponent.getClass().getName()));
            xrayDetails.put("formComponent.id", this.formComponent.getId());
            xrayDetails.put("formComponent.validators (count)", "" + _NullSafe.size((Collection)this.formComponent.getValidators()));
            xrayDetails.put("attributeModel.disableReason", String.valueOf(this.attributeModel().disabledReason().map(InteractionVeto::getReason).orElse(null)));
            xrayDetails.put("attributeModel.whetherHidden", "" + this.attributeModel().whetherHidden());
            xrayDetails.put("attributeModel.identifier", this.attributeModel().getIdentifier());
            xrayDetails.put("attributeModel.choices (count)", "" + this.attributeModel().getChoices().size());
            xrayDetails.put("attributeModel.metaModel.featureIdentifier", String.valueOf(this.attributeModel().getMetaModel().getFeatureIdentifier()));
            xrayDetails.put("attributeModel.elementTypeSpec", this.attributeModel().getElementType().toString());
            xrayDetails.put("attributeModel.proposedValue", String.valueOf(this.attributeModel().proposedValue().getValue().getValue()));
            Wkt.markupAdd(this.fieldFrame, "xrayDetails", XrayWkt.formatAsListGroup(xrayDetails));
        });
        if (renderScenario.isReadonly()) {
            this.fieldFrame.add(new Component[]{AttributeFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(this::createComponentForOutput)});
        } else if (!renderScenario.isViewingAndCanEditAny()) {
            this.getInputFragmentType().ifPresent(inputFragmentType -> this.fieldFrame.add(new Component[]{inputFragmentType.createFragment((MarkupContainer)this, this.formComponent)}));
        }
        this.onFormGroupCreated(formGroup);
        this.formComponent.setVisible(true);
        this.formComponent.setVisibilityAllowed(true);
        return formGroup;
    }

    @Override
    protected final Component createCompactFrame() {
        return AttributeFragmentFactory.FrameFragment.COMPACT.createComponent(this::createComponentForOutput);
    }

    protected Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.empty();
    }

    protected void onFormGroupCreated(FormGroup formGroup) {
    }

    @Override
    protected void onInitializeNotEditable() {
        if (this.getFormComponent() != null) {
            this.getFormComponent().setEnabled(false);
        }
        this.replaceDisabledTagWithReadonlyTagIfApplicable();
        this.clearTooltip();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        this.formComponentEnable(false);
        this.replaceDisabledTagWithReadonlyTagIfApplicable();
        this.setTooltip(disableReason);
    }

    @Override
    protected void onInitializeEditable() {
        this.formComponentEnable(true);
        this.clearTooltip();
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        this.formComponentEnable(false);
        this.setTooltip(disableReason);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        this.formComponentEnable(true);
        this.clearTooltip();
    }

    public String getVariation() {
        return XrayWkt.isEnabled() ? "xray" : super.getVariation();
    }

    private void formComponentEnable(boolean b) {
        if (this.getFormComponent() != null) {
            this.getFormComponent().setEnabled(b);
        }
        if (this.inlinePromptLink != null) {
            this.inlinePromptLink.setEnabled(b);
        }
    }

    private void setTooltip(String tooltip) {
        WktTooltips.addTooltip(this.getFormComponent(), tooltip);
        WktTooltips.addTooltip(this.inlinePromptLink, tooltip);
    }

    private void clearTooltip() {
        WktTooltips.clearTooltip(this.getFormComponent());
        WktTooltips.clearTooltip((Component)this.inlinePromptLink);
    }

    private void replaceDisabledTagWithReadonlyTagIfApplicable() {
        if (!this.getWicketViewerSettings().isReplaceDisabledTagWithReadonlyTag()) {
            return;
        }
        if (this instanceof AttributePanelWithSelect) {
            return;
        }
        Wkt.behaviorAddReplaceDisabledTagWithReadonlyTag(this.getFormComponent());
    }
}

