/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.jspecify.annotations.Nullable;

final class _Util {
    static boolean isPropertyWithEnterEditNotAvailable(UiAttributeWkt attributeModel) {
        return attributeModel.isProperty() && attributeModel.isViewingMode() && (attributeModel.getPromptStyle().isDialogAny() || !_Util.canEnterEditMode(attributeModel));
    }

    static boolean canPropertyEnterInlineEditDirectly(UiAttributeWkt attributeModel) {
        return attributeModel.getPromptStyle().isInline() && attributeModel.isViewingMode() && !attributeModel.disabledReason().isPresent();
    }

    static boolean canParameterEnterNestedEdit(UiAttributeWkt attributeModel) {
        return attributeModel.isParameter() && !attributeModel.hasChoices() && _Util.lookupCompositeValueMixinForFeature(attributeModel).isPresent();
    }

    static Optional<ActionModel> lookupMixinForCompositeValueUpdate(UiAttributeWkt attributeModel) {
        return _Util.lookupCompositeValueMixinForFeature(attributeModel).flatMap(compositeValueMixinForFeature -> _Util.toActionModelWithRuleChecking(compositeValueMixinForFeature, attributeModel)).filter(_Util::guardAgainstInvalidCompositeMixinScenarios);
    }

    static Optional<ActionModel> lookupPropertyActionForInlineEdit(UiAttributeWkt attributeModel) {
        return attributeModel.getAssociatedActions().firstAssociatedWithInlineAsIfEdit().flatMap(action -> _Util.toActionModelWithRuleChecking(action, attributeModel));
    }

    static Can<ActionModel> associatedActionModels(UiAttributeWkt attributeModel) {
        return (Can)attributeModel.getAssociatedActions().remainingAssociated().stream().map(act -> ActionModel.forPropertyOrParameter((ObjectAction)act, (UiAttributeWkt)attributeModel)).collect(Can.toCan());
    }

    static IValidator<Object> createValidatorFor(final UiAttributeWkt attributeModel) {
        return new IValidator<Object>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<Object> validatable) {
                _Util.recoverProposedValue(validatable.getValue(), attributeModel).ifPresent(proposedAdapter -> _Strings.nonEmpty((CharSequence)attributeModel.validate(proposedAdapter)).ifPresent(validationFeedback -> validatable.error((IValidationError)new ValidationError(validationFeedback))));
            }
        };
    }

    private static boolean canEnterEditMode(UiAttributeWkt attributeModel) {
        return attributeModel.isViewingMode() && !attributeModel.disabledReason().isPresent();
    }

    private static Optional<ActionModel> toActionModelNoRuleChecking(@Nullable ObjectAction action, UiAttributeWkt attributeModel) {
        return Optional.ofNullable(action).map(act -> ActionModel.forPropertyOrParameter((ObjectAction)act, (UiAttributeWkt)attributeModel));
    }

    private static Optional<ActionModel> toActionModelWithRuleChecking(@Nullable ObjectAction action, UiAttributeWkt attributeModel) {
        return _Util.toActionModelNoRuleChecking(action, attributeModel).filter(ActionModel::isVisible).filter(ActionModel::isEnabled);
    }

    private static boolean guardAgainstInvalidCompositeMixinScenarios(ActionModel actionModel) {
        _Assert.assertNotNull((Object)actionModel.getInlinePromptContext(), () -> String.format("with feature %s, for composite-value-type mixins to work an InlinePromptContext is required", actionModel.getAction().getFeatureIdentifier()));
        _Assert.assertTrue((actionModel.getPromptStyle() == PromptStyle.INLINE_AS_IF_EDIT ? 1 : 0) != 0, () -> String.format("with feature %s, for composite-value-type mixins to work PromptStyle must be INLINE_AS_IF_EDIT yet found %s", actionModel.getAction().getFeatureIdentifier(), actionModel.getPromptStyle()));
        return true;
    }

    private static Optional<ManagedObject> recoverProposedValue(Object valueObject, UiAttributeWkt attributeModel) {
        if (valueObject instanceof Collection) {
            if (attributeModel.isSingular()) {
                Optional<ManagedObject> unpackedValue = ((Collection)valueObject).stream().limit(1L).map(v -> attributeModel.getObjectManager().adapt(valueObject)).findFirst();
                return unpackedValue;
            }
            Can unpackedValues = (Can)((Collection)valueObject).stream().map(v -> attributeModel.getObjectManager().demementify((ObjectMemento)v)).collect(Can.toCan());
            return Optional.of(ManagedObject.packed((ObjectSpecification)attributeModel.getElementType(), (Can)unpackedValues));
        }
        if (valueObject instanceof ObjectMemento) {
            return Optional.ofNullable(attributeModel.getObjectManager().demementify((ObjectMemento)valueObject));
        }
        return Optional.ofNullable(attributeModel.getObjectManager().adapt(valueObject));
    }

    private static Optional<ObjectAction> lookupCompositeValueMixinForFeature(UiAttributeWkt attributeModel) {
        ObjectSpecification spec = attributeModel.getElementType();
        if (!spec.isValue()) {
            return Optional.empty();
        }
        return (Optional)attributeModel.getSpecialization().fold(param -> Facets.valueCompositeMixinForParameter((ObjectFeature)attributeModel.getMetaModel(), (ParameterNegotiationModel)param.getParameterNegotiationModel(), (int)param.getParameterIndex()), prop -> Facets.valueCompositeMixinForProperty((ObjectFeature)attributeModel.getMetaModel(), (ManagedProperty)prop.getManagedProperty()));
    }

    @Generated
    private _Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

