/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.choices;

import java.io.Serializable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AttributePanelWithSelect
extends AttributePanelWithFormField<ManagedObject> {
    private static final long serialVersionUID = 1L;
    protected Select2 select2;

    protected AttributePanelWithSelect(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel, ManagedObject.class);
        this.setOutputMarkupId(true);
    }

    protected final void createSelect2(String id) {
        this.select2 = Select2.create(id, this.attributeModel(), this.getAttributeModelChangeDispatcher());
    }

    @Override
    protected final void installModelChangeBehavior() {
    }

    protected final boolean isEditable() {
        UiAttributeWkt attributeModel = this.attributeModel();
        return !attributeModel.getRenderingHint().isInTable() && !attributeModel.isViewingMode();
    }

    protected final boolean hasAnyChoices() {
        return this.attributeModel().getChoiceProviderSort().isChoicesAny();
    }

    public final boolean checkSelect2Required() {
        return this.select2.checkRequired();
    }

    @Override
    protected final UiString obtainOutputFormat() {
        return UiString.text((String)((String)this.select2.obtainOutputFormatModel().getObject()));
    }

    @Override
    protected final void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
        Wkt.javaScriptAdd(target, Wkt.EventTopic.OPEN_SELECT2, inlinePromptForm.getMarkupId());
    }

    @Override
    public final AttributePanel.Repaint updateIfNecessary(@NonNull UiParameter paramModel) {
        return super.updateIfNecessary(paramModel).max(AttributePanel.Repaint.required(this.select2 != null));
    }

    public static interface ChoiceTitleHandler
    extends Serializable {
        public void clearTitleAttribute();

        public void setTitleAttribute(@Nullable String var1);
    }
}

