/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.facets.SingleValueFacet;
import org.apache.causeway.core.metamodel.facets.object.tabledec.TableDecoratorFacet;
import org.apache.causeway.core.metamodel.object.MmSortUtils;
import org.apache.causeway.core.metamodel.tabular.DataColumn;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CollectionContentsSortableDataProvider
extends SortableDataProvider<DataRow, String> {
    private static final long serialVersionUID = 1L;
    private final CollectionModel collectionModel;

    public CollectionContentsSortableDataProvider(CollectionModel collectionModel) {
        this.collectionModel = collectionModel;
    }

    public boolean isDecoratedWithDataTablesNet() {
        return this.getDataTableModel().getMetaModel().getFacetHolder().lookupFacet(TableDecoratorFacet.class).map(SingleValueFacet::value).map(TableDecorator.DatatablesNet.class::equals).orElse(false);
    }

    public DataTableInteractive getDataTableModel() {
        return this.applyColumnSortTo(this.dataTableInternal());
    }

    public IModel<DataRow> model(DataRow dataRow) {
        return new DataRowWkt(dataRow.rowIndex(), this.collectionModel);
    }

    public long size() {
        return this.getDataTableModel().getFilteredElementCount();
    }

    public Iterator<DataRow> iterator(long skip, long limit) {
        DataTableInteractive dataTable = this.getDataTableModel();
        return ((Can)dataTable.dataRowsFilteredAndSortedObservable().getValue()).iterator(Math.toIntExact(skip), Math.toIntExact(limit));
    }

    private DataTableInteractive dataTableInternal() {
        return (DataTableInteractive)this.collectionModel.getObject();
    }

    private DataTableInteractive applyColumnSortTo(DataTableInteractive dataTableInteractive) {
        DataTableInteractive.ColumnSort newColumnSort;
        DataTableInteractive.ColumnSort oldColumnSort = (DataTableInteractive.ColumnSort)dataTableInteractive.columnSortBindable().getValue();
        if (!Objects.equals(oldColumnSort, newColumnSort = (DataTableInteractive.ColumnSort)this.columnSort().orElse(null))) {
            dataTableInteractive.columnSortBindable().setValue((Object)newColumnSort);
        }
        return dataTableInteractive;
    }

    private Optional<DataTableInteractive.ColumnSort> columnSort() {
        SortParam sortParam = this.getSort();
        return this.lookupColumnIndexFor((SortParam<String>)sortParam).stream().mapToObj(columnIndex -> new DataTableInteractive.ColumnSort(columnIndex, CollectionContentsSortableDataProvider.sortDirection((SortParam<String>)sortParam))).findFirst();
    }

    private OptionalInt lookupColumnIndexFor(@Nullable SortParam<String> sortParam) {
        if (sortParam == null) {
            return OptionalInt.empty();
        }
        int columnIndex = 0;
        for (DataColumn column : (Can)this.dataTableInternal().dataColumnsObservable().getValue()) {
            if (column.associationMetaModel().getId().equals(sortParam.getProperty())) {
                return OptionalInt.of(columnIndex);
            }
            ++columnIndex;
        }
        return OptionalInt.empty();
    }

    private static MmSortUtils.SortDirection sortDirection(@NonNull SortParam<String> sortParam) {
        return sortParam.isAscending() ? MmSortUtils.SortDirection.ASCENDING : MmSortUtils.SortDirection.DESCENDING;
    }
}

