/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.GenericColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class AssociationColumnAbstract
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    protected final CollectionModel.Variant collectionVariant;
    protected final String memberId;
    protected final String parentTypeName;
    protected final String describedAs;

    public AssociationColumnAbstract(ObjectSpecification elementType, CollectionModel.Variant collectionVariant, IModel<String> columnNameModel, Optional<String> sortProperty, String memberId, String parentTypeName, Optional<String> describedAs) {
        super(elementType, columnNameModel, sortProperty.orElse(null));
        this.collectionVariant = collectionVariant;
        this.memberId = memberId;
        this.parentTypeName = parentTypeName;
        this.describedAs = describedAs.orElse(null);
    }

    public final Component getHeader(String componentId) {
        Label label = new Label(componentId, this.getDisplayModel());
        label.setEscapeModelStrings(true);
        if (this.describedAs != null) {
            WktTooltips.addTooltip(label, this.describedAs);
        }
        return label;
    }

    public final String getCssClass() {
        String cssClass = super.getCssClass();
        return (String)(_Strings.isNotEmpty((CharSequence)cssClass) ? cssClass + " " : "") + Wkt.cssNormalize("causeway-" + this.parentTypeName + "-" + this.memberId);
    }
}

