/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.property;

import java.io.Serializable;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

class PropertyEditPanel
extends PanelAbstract<ManagedObject, PropertyModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_PROPERTY_NAME = "propertyName";
    private boolean showHeader = true;

    public PropertyEditPanel(String id, PropertyModel propertyModel) {
        super(id, propertyModel.copyHaving(ViewOrEditMode.EDITING, RenderingHint.REGULAR));
        this.buildGui(propertyModel);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui(this.propertyModel());
    }

    PropertyModel propertyModel() {
        return (PropertyModel)super.getModel();
    }

    public PropertyEditPanel setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    private void buildGui(PropertyModel propertyModel) {
        WebMarkupContainer header = this.addHeader();
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.propertyModel());
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, UiComponentType.OBJECT_ICON_AND_TITLE, (IModel<?>)propertyModel.getParentUiModel());
        Wkt.labelAdd((MarkupContainer)header, ID_PROPERTY_NAME, (IModel<String>)((IModel & Serializable)() -> ((PropertyModel)this.propertyModel()).getFriendlyName())).setEscapeModelStrings(true);
    }

    private WebMarkupContainer addHeader() {
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(PropertyEditPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        return header;
    }
}

