/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import java.util.Optional;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.GenericColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.jspecify.annotations.NonNull;

public final class ActionColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final Can<String> actionIds;
    private transient Can<ObjectAction> actions;
    private final CollectionModel.Variant collectionVariant;

    public static Optional<ActionColumn> create(@NonNull Identifier featureId, @NonNull ObjectSpecification elementType, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CollectionModel.Variant collectionVariant) {
        CausewayConfiguration.Viewer.Wicket wktConfig = elementType.getMetaModelContext().getConfiguration().getViewer().getWicket();
        if (!wktConfig.isActionColumnEnabled()) {
            return Optional.empty();
        }
        Can actions = (Can)elementType.streamActionsForColumnRendering(featureId).collect(Can.toCan());
        if (actions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ActionColumn(elementType, (Can<ObjectAction>)actions, collectionVariant));
    }

    private ActionColumn(ObjectSpecification elementType, Can<ObjectAction> actionsForColumnRendering, CollectionModel.Variant collectionVariant) {
        super(elementType, "Actions");
        this.actions = actionsForColumnRendering;
        this.actionIds = this.actions.map(ObjectFeature::getId);
        this.collectionVariant = collectionVariant;
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataRow dataRow = dataRowWkt.getObject();
        ManagedObject rowElement = dataRow.rowElement();
        UiObjectWkt objectModel = UiObjectWkt.ofAdapter((ManagedObject)rowElement);
        ObjectSpecification elementType = this.elementType();
        Can actionModels = (Can)this.actions().stream().map(act -> ActionModel.forEntityFromActionColumn((ObjectAction)act, (UiObjectWkt)objectModel, (ActionModel.ColumnActionModifier)this.determineColumnActionModifier((ObjectAction)act, elementType))).collect(Can.toCan());
        return ActionLinksPanel.actionLinks(componentId, (Can<ActionModel>)actionModels, ActionLinksPanel.Style.DROPDOWN).map(Component.class::cast).orElseGet(() -> Wkt.label(componentId, ""));
    }

    private ActionModel.ColumnActionModifier determineColumnActionModifier(ObjectAction action, ObjectSpecification collectionElementType) {
        if (this.collectionVariant.isStandalone()) {
            return ActionModel.ColumnActionModifier.FORCE_NEW_BROWSER_WINDOW;
        }
        return action.getElementType().isVoid() || action.getElementType().isOfType(collectionElementType) ? ActionModel.ColumnActionModifier.FORCE_STAY_ON_PAGE : ActionModel.ColumnActionModifier.FORCE_NEW_BROWSER_WINDOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Can<ObjectAction> actions() {
        ActionColumn actionColumn = this;
        synchronized (actionColumn) {
            if (this.actions == null) {
                ObjectSpecification elementType = this.elementType();
                this.actions = this.actionIds.map(arg_0 -> ((ObjectSpecification)elementType).getActionElseFail(arg_0));
            }
        }
        return this.actions;
    }
}

