/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.multiple;

import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.CausewayEnvelopeEvent;
import org.apache.causeway.viewer.wicket.model.hints.CausewaySelectorEvent;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

class CollectionContentsMultipleViewsPanel
extends PanelAbstract<DataTableInteractive, CollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String UIHINT_VIEW = "selectedItem";
    private final String underlyingIdPrefix = UiComponentType.COLLECTION_CONTENTS.toString();
    private final CollectionPresentationSelectorHelper selectorHelper;
    private Component selectedComponent;
    private Component[] underlyingViews;

    public CollectionContentsMultipleViewsPanel(String id, CollectionModel model) {
        super(id, model);
        ComponentHintKey selectedItemSessionAttribute = model.getVariant().isParented() ? ComponentHintKey.create((MetaModelContext)super.getMetaModelContext(), (Component)this, (String)UIHINT_VIEW) : null;
        this.selectorHelper = new CollectionPresentationSelectorHelper(model, this.getComponentFactoryRegistry(), selectedItemSessionAttribute);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addUnderlyingViews();
    }

    private void addUnderlyingViews() {
        CollectionModel visibleCollModel = (CollectionModel)this.getModel();
        CollectionModel hiddenCollModel = CollectionModel.empty();
        Can<ComponentFactoryKey> componentFactoryKeys = this.selectorHelper.factoryKeys();
        CollectionPresentationSelectorPanel selectorDropdownPanelIfAny = CollectionPresentationSelectorProvider.getCollectionSelectorProvider((Component)this);
        String selectedCompFactoryName = selectorDropdownPanelIfAny != null ? this.selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanelIfAny) : ((ComponentFactoryKey)componentFactoryKeys.getFirstElseFail()).id();
        int i = 0;
        int selectedIdx = 0;
        this.underlyingViews = new Component[10];
        for (ComponentFactoryKey componentFactoryKey : componentFactoryKeys) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            boolean isSelected = selectedCompFactoryName.equals(componentFactoryKey.id());
            Component underlyingView = componentFactoryKey.componentFactory().createComponent(underlyingId, (IModel<?>)(isSelected ? visibleCollModel : hiddenCollModel));
            if (isSelected) {
                selectedIdx = i;
            }
            this.underlyingViews[i++] = underlyingView;
            this.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            WktComponents.permanentlyHide((MarkupContainer)this, underlyingId);
            ++i;
        }
        this.setOutputMarkupId(true);
        for (i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            if (i != selectedIdx) {
                PanelAbstract.setVisible(component, false);
                continue;
            }
            this.selectedComponent = component;
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        CausewaySelectorEvent selectorEvent = (CausewaySelectorEvent)CausewayEnvelopeEvent.openLetter(event, CausewaySelectorEvent.class);
        if (selectorEvent == null) {
            return;
        }
        CollectionPresentationSelectorPanel selectorDropdownPanel = CollectionPresentationSelectorProvider.getCollectionSelectorProvider((Component)this);
        if (selectorDropdownPanel == null) {
            return;
        }
        String selectedView = selectorEvent.hintFor((Component)selectorDropdownPanel, UIHINT_VIEW);
        if (selectedView == null) {
            return;
        }
        AjaxRequestTarget ajaxTarget = selectorEvent.getTarget();
        int underlyingViewNum = this.selectorHelper.lookup(selectedView);
        for (int i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            boolean isSelected = i == underlyingViewNum;
            CollectionContentsMultipleViewsPanel.setVisible(component, isSelected);
            component.setDefaultModel((IModel)(isSelected ? this.getModel() : CollectionModel.empty()));
            if (!isSelected || ajaxTarget == null || !component.getOutputMarkupId()) continue;
            ajaxTarget.add(new Component[]{component});
        }
        this.selectedComponent = this.underlyingViews[underlyingViewNum];
        if (ajaxTarget != null) {
            ajaxTarget.add(new Component[]{this, selectorDropdownPanel});
        }
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

