/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.nav.selop;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.tableoption.SelectOperationChoice;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.jspecify.annotations.NonNull;

public class SelectOperationChooser
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_SELECT_OPERATION_BUTTON = "selectOperationButton";
    private static final String ID_SELECT_OPERATION_CHOICE = "selectOperationChoice";
    private static final String ID_SELECT_OPERATION_CHOICES = "selectOperationChoices";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    final DataTableWithPagesAndFilter<?, ?> table;

    public SelectOperationChooser(String id, DataTableWithPagesAndFilter<?, ?> table) {
        super(id);
        this.table = table;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        List<SelectOperationChoice> selectOperationChoices = this.table.getSelectOperationChoices();
        Button button = Wkt.add((MarkupContainer)this, new Button(ID_SELECT_OPERATION_BUTTON));
        Wkt.listViewAdd((MarkupContainer)this, ID_SELECT_OPERATION_CHOICES, selectOperationChoices, (SerializableConsumer & Serializable)item -> {
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_SELECT_OPERATION_CHOICE, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                SelectOperationChoice selectOperationChoice = (SelectOperationChoice)item.getModelObject();
                this.table.executeSelectOperation(selectOperationChoice);
                target.add(new Component[]{this.table});
            });
            SelectOperationChooser.addIconAndTitle((ListItem<SelectOperationChoice>)item, link);
            Wkt.ajaxEnable(link);
        });
        if (selectOperationChoices.isEmpty()) {
            this.setVisible(false);
        } else {
            WktTooltips.addTooltip(button, this.translate("Select operations"));
        }
    }

    private String translate(String text) {
        return MetaModelContext.translationServiceOrFallback().translate(TranslationContext.named((String)"Table"), text);
    }

    private static void addIconAndTitle(@NonNull ListItem<SelectOperationChoice> item, @NonNull AjaxLinkNoPropagate link) {
        WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, pagesizeChoice -> Model.of((Serializable)((Object)pagesizeChoice.translatedTitle())), ID_VIEW_ITEM_ICON, pagesizeChoice -> FontAwesomeLayers.fromQuickNotation((String)pagesizeChoice.faIconCss()));
    }

    @Generated
    public DataTableWithPagesAndFilter<?, ?> getTable() {
        return this.table;
    }
}

