/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.wicketapp;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.commons.internal.concurrent._ConcurrentContext;
import org.apache.causeway.commons.internal.concurrent._ConcurrentTaskList;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.viewer.wicket.model.causeway.WicketApplicationInitializer;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.HasPageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.causeway.viewer.wicket.ui.pages.login.WicketLogoutPage;
import org.apache.causeway.viewer.wicket.viewer.integration.AuthenticatedWebSessionForCauseway;
import org.apache.causeway.viewer.wicket.viewer.integration.CausewayResourceSettings;
import org.apache.causeway.viewer.wicket.viewer.integration.ConverterForObjectAdapter;
import org.apache.causeway.viewer.wicket.viewer.integration.ConverterForObjectAdapterMemento;
import org.apache.causeway.viewer.wicket.viewer.integration.WebRequestCycleForCauseway;
import org.apache.causeway.viewer.wicket.viewer.wicketapp.CausewayWicketAjaxRequestListenerUtil;
import org.apache.causeway.viewer.wicket.viewer.wicketapp.TargetRespondListenerToResetQueryResultCache;
import org.apache.causeway.viewer.wicket.viewer.wicketapp._CryptFactory;
import org.apache.causeway.viewer.wicket.viewer.wicketapp._PageFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.ResourceAggregator;
import org.apache.wicket.markup.head.filter.JavaScriptFilteredIntoFooterHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.settings.RequestCycleSettings;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.convert.IConverter;
import org.springframework.stereotype.Component;

public class CausewayWicketApplication
extends AuthenticatedWebApplication
implements HasComponentFactoryRegistry,
HasPageClassRegistry,
HasMetaModelContext {
    @Generated
    private static final Logger log = LogManager.getLogger(CausewayWicketApplication.class);
    private static final long serialVersionUID = 1L;
    @Inject
    private MetaModelContext metaModelContext;
    @Inject
    private List<WicketApplicationInitializer> applicationInitializers;
    @Inject
    private CausewaySystemEnvironment systemEnvironment;
    @Inject
    private CausewayConfiguration configuration;
    @Inject
    private ComponentFactoryRegistry componentFactoryRegistry;
    @Inject
    private PageClassRegistry pageClassRegistry;
    protected static final Function<ComponentFactory, Iterable<CssResourceReference>> getCssResourceReferences = input -> {
        CssResourceReference cssResourceReference = input.getCssResourceReference();
        return cssResourceReference != null ? Collections.singletonList(cssResourceReference) : Collections.emptyList();
    };

    public static CausewayWicketApplication get() {
        return (CausewayWicketApplication)AuthenticatedWebApplication.get();
    }

    public CausewayWicketApplication() {
        System.setProperty("wicket.ioc.useByteBuddy", "true");
    }

    protected void internalInit() {
        this.setResourceSettings(new CausewayResourceSettings((Application)this));
        super.internalInit();
        CausewayWicketAjaxRequestListenerUtil.setRootRequestMapper((WebApplication)this, this.metaModelContext);
    }

    private AjaxRequestTarget decorate(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.registerRespondListener((AjaxRequestTarget.ITargetRespondListener)this.metaModelContext.injectServicesInto((Object)new TargetRespondListenerToResetQueryResultCache()));
        return ajaxRequestTarget;
    }

    public Application setAjaxRequestTargetProvider(Function<Page, AjaxRequestTarget> ajaxRequestTargetProvider) {
        Application application = super.setAjaxRequestTargetProvider(context -> this.decorate((AjaxRequestTarget)ajaxRequestTargetProvider.apply((Page)context)));
        return application;
    }

    protected void init() {
        super.init();
        SpringComponentInjector springInjector = new SpringComponentInjector((WebApplication)this);
        this.getComponentInstantiationListeners().add((Object)springInjector);
        ServiceInjectorHolder serviceInjectorHolder = new ServiceInjectorHolder();
        springInjector.inject((Object)serviceInjectorHolder);
        serviceInjectorHolder.serviceInjector.injectServicesInto((Object)this);
        _ConcurrentTaskList initializationTasks = _ConcurrentTaskList.named((String)"Causeway Application Initialization Tasks");
        this.applicationInitializers.forEach(initializer -> initializationTasks.addRunnable(String.format("Configure %s", initializer.getClass().getSimpleName()), () -> initializer.init((WebApplication)this)));
        try {
            initializationTasks.submit(_ConcurrentContext.sequential()).await();
            this.getRequestCycleSettings().setRenderStrategy(RequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER);
            this.getResourceSettings().setParentFolderPlaceholder("$up$");
            this.getRequestCycleListeners().add((Object)this.createWebRequestCycleListenerForCauseway());
            this.getRequestCycleListeners().add((Object)new PageRequestHandlerTracker());
            this.getPageSettings().setRecreateBookmarkablePagesAfterExpiry(false);
            this.getMarkupSettings().setStripWicketTags(this.configuration.getViewer().getWicket().isStripWicketTags());
            this.configureSecurity(this.configuration);
            this.filterJavascriptContributions();
            this.mountPages();
            log.debug("storeSettings.asynchronousQueueCapacity: {}", (Object)this.getStoreSettings().getAsynchronousQueueCapacity());
            log.debug("storeSettings.maxSizePerSession        : {}", (Object)this.getStoreSettings().getMaxSizePerSession());
            log.debug("storeSettings.fileStoreFolder          : {}", (Object)this.getStoreSettings().getFileStoreFolder());
        }
        catch (RuntimeException ex) {
            log.error("Failed to initialize", (Throwable)ex);
            throw ex;
        }
    }

    protected IPageFactory newPageFactory() {
        return new _PageFactory(this, super.newPageFactory());
    }

    protected void configureSecurity(CausewayConfiguration configuration) {
        this.getCspSettings().blocking().disabled();
        this.getSecuritySettings().setAuthenticationStrategy(this.newAuthenticationStrategy(configuration));
        int maxEntries = 1000;
        this.setMetaData(AccountConfirmationMap.KEY, new AccountConfirmationMap(1000, Duration.ofDays(1L)));
    }

    protected IAuthenticationStrategy newAuthenticationStrategy(CausewayConfiguration configuration) {
        CausewayConfiguration.Viewer.Wicket.RememberMe rememberMe = configuration.getViewer().getWicket().getRememberMe();
        String cookieKey = rememberMe.getCookieKey();
        String encryptionKey = rememberMe.getEncryptionKey().orElse(this.defaultEncryptionKey());
        return new DefaultAuthenticationStrategy(cookieKey, _CryptFactory.sunJceCrypt(encryptionKey));
    }

    protected String defaultEncryptionKey() {
        return this.systemEnvironment.isPrototyping() ? "PrototypingEncryptionKey" : UUID.randomUUID().toString();
    }

    protected IRequestCycleListener createWebRequestCycleListenerForCauseway() {
        WebRequestCycleForCauseway webRequestCycleForCauseway = new WebRequestCycleForCauseway();
        webRequestCycleForCauseway.setPageClassRegistry(this.getPageClassRegistry());
        return webRequestCycleForCauseway;
    }

    protected void filterJavascriptContributions() {
        this.getHeaderResponseDecorators().replaceAll(response -> new ResourceAggregator((IHeaderResponse)new JavaScriptFilteredIntoFooterHeaderResponse(response, "footerJS")));
    }

    protected void mountPages() {
        this.mountPage("/signin", PageType.SIGN_IN);
        this.mountPage("/signup", PageType.SIGN_UP);
        this.mountPage("/signup/verify", PageType.SIGN_UP_VERIFY);
        this.mountPage("/password/reset", PageType.PASSWORD_RESET);
        this.mountPage("/entity/#{objectOid}", PageType.ENTITY);
        this.mountPage("/logout", WicketLogoutPage.class);
    }

    protected void mountPage(String mountPath, PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        this.mount((IRequestMapper)new MountedMapper(mountPath, pageClass));
    }

    public final RuntimeConfigurationType getConfigurationType() {
        if (this.systemEnvironment == null) {
            return RuntimeConfigurationType.DEPLOYMENT;
        }
        return this.systemEnvironment.isPrototyping() ? RuntimeConfigurationType.DEVELOPMENT : RuntimeConfigurationType.DEPLOYMENT;
    }

    protected void onDestroy() {
        try {
            super.onDestroy();
        }
        catch (RuntimeException ex) {
            log.error("Failed to destroy", (Throwable)ex);
            throw ex;
        }
    }

    protected Class<? extends AuthenticatedWebSession> getWebSessionClass() {
        return AuthenticatedWebSessionForCauseway.class;
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator converterLocator = new ConverterLocator();
        converterLocator.set(ManagedObject.class, (IConverter)new ConverterForObjectAdapter());
        converterLocator.set(ObjectMemento.class, (IConverter)new ConverterForObjectAdapterMemento());
        return converterLocator;
    }

    public Class<? extends Page> getHomePage() {
        return this.getPageClassRegistry().getPageClass(PageType.HOME);
    }

    public Class<? extends WebPage> getSignInPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
    }

    public Class<? extends WebPage> getSignUpPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP);
    }

    public Class<? extends WebPage> getSignUpVerifyPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP_VERIFY);
    }

    public Class<? extends WebPage> getForgotPasswordPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.PASSWORD_RESET);
    }

    @Generated
    public MetaModelContext getMetaModelContext() {
        return this.metaModelContext;
    }

    @Generated
    public ComponentFactoryRegistry getComponentFactoryRegistry() {
        return this.componentFactoryRegistry;
    }

    @Generated
    public PageClassRegistry getPageClassRegistry() {
        return this.pageClassRegistry;
    }

    @Component
    static class ServiceInjectorHolder {
        @Inject
        ServiceInjector serviceInjector;

        ServiceInjectorHolder() {
        }
    }
}

