/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.integration;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.causeway.applib.services.exceprecog.Recognition;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.error.ErrorPage;
import org.apache.causeway.viewer.wicket.ui.pages.login.WicketSignInPage;
import org.apache.causeway.viewer.wicket.ui.pages.mmverror.MmvErrorPage;
import org.apache.causeway.viewer.wicket.viewer.integration.AuthenticatedWebSessionForCauseway;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.wicket.Application;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.lang.Nullable;

public class WebRequestCycleForCauseway
implements HasCommonContext,
IRequestCycleListener {
    private static final Logger log = LogManager.getLogger(WebRequestCycleForCauseway.class);
    private static final MetaDataKey<SessionLifecyclePhase> SESSION_LIFECYCLE_PHASE_KEY = new MetaDataKey<SessionLifecyclePhase>(){
        private static final long serialVersionUID = 1L;
    };
    private PageClassRegistry pageClassRegistry;
    private static final ExceptionRecognizerForType pageExpiredExceptionRecognizer = new ExceptionRecognizerForType(PageExpiredException.class, __ -> "Requested page is no longer available.");

    public synchronized void onBeginRequest(RequestCycle requestCycle) {
        InteractionContext interactionContext0;
        log.debug("onBeginRequest in");
        if (!Session.exists()) {
            if (this.userHasSessionWithRememberMe(requestCycle)) {
                requestCycle.setMetaData(SESSION_LIFECYCLE_PHASE_KEY, (Object)SessionLifecyclePhase.EXPIRED);
                log.debug("flagging the RequestCycle as expired (rememberMe feature is active for the current user)");
            }
            log.debug("onBeginRequest out - session was not opened (because no Session)");
            return;
        }
        InteractionService interactionService = this.getInteractionService();
        AuthenticatedWebSessionForCauseway authenticatedWebSession = AuthenticatedWebSessionForCauseway.get();
        Optional currentInteractionContext = interactionService.currentInteractionContext();
        if (currentInteractionContext.isPresent()) {
            if (((InteractionContext)currentInteractionContext.get()).getUser().isImpersonating()) {
                throw _Exceptions.illegalState((String)"cannot enter a new request cycle with a left over impersonating user", (Object[])new Object[0]);
            }
            authenticatedWebSession.setPrimedInteractionContext((InteractionContext)currentInteractionContext.get());
        }
        if ((interactionContext0 = authenticatedWebSession.getInteractionContext()) == null) {
            log.warn("onBeginRequest out - session was not opened (because no authentication)");
            return;
        }
        InteractionContext interactionContext1 = ((UserService)this.lookupServiceElseFail(UserService.class)).lookupImpersonatedUser().map(sudoUser -> interactionContext0.withUser(sudoUser)).orElse(interactionContext0);
        interactionService.openInteraction(interactionContext1);
        log.debug("onBeginRequest out - session was opened");
    }

    public void onRequestHandlerResolved(RequestCycle requestCycle, IRequestHandler handler) {
        log.debug("onRequestHandlerResolved in (handler: {}, hasSession: {})", new Supplier[]{() -> handler.getClass().getName(), () -> Session.exists() ? Integer.valueOf(Session.get().hashCode()) : "false"});
        if ("org.apache.wicket.request.flow.ResetResponseException$ResponseResettingDecorator".equals(handler.getClass().getName()) && SessionLifecyclePhase.isExpired(requestCycle)) {
            log.debug("Transferring the 'expired' flag into the current session.");
            SessionLifecyclePhase.transferExpiredFlagToSession();
        } else if (handler instanceof RenderPageRequestHandler) {
            ValidationFailures validationResult = (ValidationFailures)this.getMetaModelContext().getSpecificationLoader().getValidationResult().orElseThrow(() -> _Exceptions.illegalState((String)"Application is not fully initialized yet.", (Object[])new Object[0]));
            if (validationResult.hasFailures()) {
                RenderPageRequestHandler requestHandler = (RenderPageRequestHandler)handler;
                IRequestablePage nextPage = requestHandler.getPage();
                if (nextPage instanceof ErrorPage || nextPage instanceof MmvErrorPage) {
                    return;
                }
                throw new MetaModelInvalidException(validationResult.getAsLineNumberedString());
            }
            if (SessionLifecyclePhase.isActiveAfterExpired()) {
                if (SessionLifecyclePhase.isExpiryMessageTimeframeExpired()) {
                    log.debug("clear the session's active-after-expired flag (expiry-message timeframe has expired");
                    SessionLifecyclePhase.clearExpiredFlag();
                } else {
                    this.getMessageBroker().ifPresent(broker -> {
                        log.debug("render 'expired' message");
                        broker.addMessage(this.translate("You have been redirected to the home page as your session expired (no recent activity)."));
                    });
                }
            }
        }
        log.debug("onRequestHandlerResolved out");
    }

    public void onRequestHandlerExecuted(RequestCycle requestCycle, IRequestHandler handler) {
        log.debug("onRequestHandlerExecuted: handler: {}", (Object)handler.getClass().getName());
    }

    public synchronized void onEndRequest(RequestCycle requestCycle) {
        log.debug("onEndRequest");
        this.getMetaModelContext().lookupService(InteractionService.class).ifPresent(InteractionService::closeInteractionLayers);
    }

    public void onDetach(RequestCycle requestCycle) {
        super.onDetach(requestCycle);
    }

    public IRequestHandler onException(RequestCycle cycle, Exception ex) {
        log.debug("onException {}", (Object)ex.getClass().getSimpleName());
        ValidationFailures validationResult = this.getMetaModelContext().getSpecificationLoader().getValidationResult().orElse(null);
        if (validationResult != null && validationResult.hasFailures()) {
            MmvErrorPage mmvErrorPage = new MmvErrorPage((Collection)validationResult.getMessages("[%d] %s"));
            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)mmvErrorPage), RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
        }
        try {
            if (ex instanceof ListenerInvocationNotAllowedException) {
                ListenerInvocationNotAllowedException linaex = (ListenerInvocationNotAllowedException)ex;
                if (linaex.getComponent() == null || !"cancelButton".equals(linaex.getComponent().getId())) {
                    this.addActionNoLongerAvailableMessage(null);
                }
                return this.respondGracefully(cycle);
            }
            ExceptionRecognizerService exceptionRecognizerService = this.getExceptionRecognizerService();
            Optional recognizedIfAny = exceptionRecognizerService.recognize((Throwable)ex);
            if (recognizedIfAny.isPresent()) {
                this.addWarning(((Recognition)recognizedIfAny.get()).toMessage(this.getMetaModelContext().getTranslationService()));
                return this.respondGracefully(cycle);
            }
            List causalChain = _Exceptions.getCausalChain((Throwable)ex);
            Optional<Throwable> hiddenIfAny = causalChain.stream().filter(ObjectMember.HiddenException::isInstanceOf).findFirst();
            if (hiddenIfAny.isPresent()) {
                this.addActionNoLongerAvailableMessage("hidden");
                return this.respondGracefully(cycle);
            }
            Optional<Throwable> disabledIfAny = causalChain.stream().filter(ObjectMember.DisabledException::isInstanceOf).findFirst();
            if (disabledIfAny.isPresent()) {
                this.addActionNoLongerAvailableMessage(disabledIfAny.get().getMessage());
                return this.respondGracefully(cycle);
            }
        }
        catch (Exception exceptionRecognizerService) {
            // empty catch block
        }
        PageProvider errorPageProvider = this.errorPageProviderFor(ex);
        RenderPageRequestHandler.RedirectPolicy redirectPolicy = ex instanceof PageExpiredException ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
        return errorPageProvider != null ? new RenderPageRequestHandler((IPageProvider)errorPageProvider, redirectPolicy) : null;
    }

    private IRequestHandler respondGracefully(RequestCycle cycle) {
        IRequestablePage page = PageRequestHandlerTracker.getFirstHandler((RequestCycle)cycle).getPage();
        PageProvider pageProvider = new PageProvider(page);
        return new RenderPageRequestHandler((IPageProvider)pageProvider);
    }

    private void addWarning(@Nullable String translatedWarning) {
        _Strings.nonEmpty((CharSequence)translatedWarning).ifPresent(warning -> this.getMessageBroker().ifPresent(broker -> broker.addWarning(warning)));
    }

    private void addActionNoLongerAvailableMessage(@Nullable String suffixIfAny) {
        this.getMessageBroker().ifPresent(broker -> {
            String translatedPrefix = this.translate("Action no longer available");
            String message = suffixIfAny != null ? String.format("%s (%s)", translatedPrefix, this.translate(suffixIfAny)) : translatedPrefix;
            broker.addMessage(message);
        });
    }

    public String translate(String text) {
        return this.translate(TranslationContext.forClassName(WebRequestCycleForCauseway.class), text);
    }

    protected PageProvider errorPageProviderFor(Exception ex) {
        IRequestablePage errorPage = this.errorPageFor(ex);
        return errorPage != null ? new PageProvider(errorPage) : null;
    }

    protected IRequestablePage errorPageFor(Exception ex) {
        MetaModelContext mmc = this.getMetaModelContext();
        if (mmc == null) {
            log.warn("Unable to obtain the MetaModelContext (no session?)");
            return null;
        }
        ValidationFailures validationResult = this.getMetaModelContext().getSpecificationLoader().getValidationResult().orElse(null);
        if (validationResult != null && validationResult.hasFailures()) {
            return new MmvErrorPage((Collection)validationResult.getMessages("[%d] %s"));
        }
        ExceptionRecognizerService exceptionRecognizerService = (ExceptionRecognizerService)this.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
        Optional recognition = exceptionRecognizerService.recognizeFromSelected(Can.ofSingleton((Object)pageExpiredExceptionRecognizer).addAll(exceptionRecognizerService.getExceptionRecognizers()), (Throwable)ex);
        ExceptionModel exceptionModel = ExceptionModel.create((MetaModelContext)mmc, (Optional)recognition, (Exception)ex);
        return this.isSignedIn() ? new ErrorPage(exceptionModel) : this.newSignInPage(exceptionModel);
    }

    private IRequestablePage newSignInPage(ExceptionModel exceptionModel) {
        Page signInPage;
        Class signInPageClass = null;
        if (this.pageClassRegistry != null) {
            signInPageClass = this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
        }
        if (signInPageClass == null) {
            signInPageClass = WicketSignInPage.class;
        }
        PageParameters parameters = new PageParameters();
        try {
            Constructor constructor = signInPageClass.getConstructor(PageParameters.class, ExceptionModel.class);
            signInPage = (Page)constructor.newInstance(parameters, exceptionModel);
        }
        catch (Exception ex) {
            try {
                IPageFactory pageFactory = Application.get().getPageFactory();
                signInPage = (Page)pageFactory.newPage(signInPageClass, parameters);
            }
            catch (Exception x) {
                throw new WicketRuntimeException("Cannot instantiate the configured sign in page", (Throwable)x);
            }
        }
        return signInPage;
    }

    protected boolean isSignedIn() {
        if (!this.isInInteraction()) {
            return false;
        }
        return this.getWicketAuthenticatedWebSession().isSignedIn();
    }

    private boolean userHasSessionWithRememberMe(RequestCycle requestCycle) {
        Object containerRequest = requestCycle.getRequest().getContainerRequest();
        if (containerRequest instanceof HttpServletRequest) {
            Can cookies = Can.ofArray((Object[])((HttpServletRequest)containerRequest).getCookies());
            String cookieKey = _Strings.nullToEmpty((String)this.getConfiguration().getViewer().getWicket().getRememberMe().getCookieKey());
            for (Cookie cookie : cookies) {
                if (!cookieKey.equals(cookie.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private ExceptionRecognizerService getExceptionRecognizerService() {
        return (ExceptionRecognizerService)this.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
    }

    private boolean isInInteraction() {
        return this.getMetaModelContext().getInteractionService().isInInteraction();
    }

    private AuthenticatedWebSession getWicketAuthenticatedWebSession() {
        return AuthenticatedWebSession.get();
    }

    public void setPageClassRegistry(PageClassRegistry pageClassRegistry) {
        this.pageClassRegistry = pageClassRegistry;
    }

    private static enum SessionLifecyclePhase {
        DONT_CARE,
        EXPIRED,
        ACTIVE_AFTER_EXPIRED;


        static boolean isExpired(RequestCycle requestCycle) {
            return Session.exists() && EXPIRED == requestCycle.getMetaData(SESSION_LIFECYCLE_PHASE_KEY);
        }

        static boolean isActiveAfterExpired() {
            return Session.exists() && ACTIVE_AFTER_EXPIRED == Session.get().getMetaData(SESSION_LIFECYCLE_PHASE_KEY);
        }

        static void transferExpiredFlagToSession() {
            Session.get().setMetaData(SESSION_LIFECYCLE_PHASE_KEY, (Serializable)((Object)ACTIVE_AFTER_EXPIRED));
            Session.get().setAttribute("session-expiry-message-timeframe", (Serializable)LocalDateTime.now().plusNanos(1000000000L));
        }

        static void clearExpiredFlag() {
            Session.get().setMetaData(SESSION_LIFECYCLE_PHASE_KEY, (Serializable)((Object)DONT_CARE));
        }

        static boolean isExpiryMessageTimeframeExpired() {
            LocalDateTime sessionExpiryMessageTimeframe = (LocalDateTime)Session.get().getAttribute("session-expiry-message-timeframe");
            return sessionExpiryMessageTimeframe == null || LocalDateTime.now().isAfter(sessionExpiryMessageTimeframe);
        }
    }
}

