/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.services;

import jakarta.annotation.Priority;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.hint.HintStore;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Session;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.HintStoreUsingWicketSession")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="Wicket")
public class HintStoreUsingWicketSession
implements HintStore {
    private static final Logger log = LogManager.getLogger(HintStoreUsingWicketSession.class);

    public String get(Bookmark bookmark, String key) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        String value = hintsForBookmark.get(key);
        if (log.isDebugEnabled()) {
            log.debug(String.format("GET %s / %s returns %s", bookmark.toString(), key, value));
        }
        return value;
    }

    public void set(Bookmark bookmark, String key, String value) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        if (log.isDebugEnabled()) {
            log.debug(String.format("SET %s / %s to %s", bookmark.toString(), key, value));
        }
        hintsForBookmark.put(key, value);
    }

    public void remove(Bookmark bookmark, String key) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        if (log.isDebugEnabled()) {
            log.debug(String.format("REMOVE %s / %s", bookmark.toString(), key));
        }
        hintsForBookmark.remove(key);
    }

    public Set<String> findHintKeys(Bookmark bookmark) {
        Map<String, String> hintsForBookmark = this.hintsFor(bookmark);
        return hintsForBookmark.keySet();
    }

    public void removeAll(Bookmark bookmark) {
        String sessionAttribute = this.sessionAttributeFor(bookmark);
        Session.get().removeAttribute(sessionAttribute);
    }

    protected Map<String, String> hintsFor(Bookmark bookmark) {
        String sessionAttribute = this.sessionAttributeFor(bookmark);
        LinkedHashMap hints = (LinkedHashMap)_Casts.uncheckedCast((Object)Session.get().getAttribute(sessionAttribute));
        if (hints == null) {
            hints = _Maps.newLinkedHashMap();
            Session.get().setAttribute(sessionAttribute, (Serializable)hints);
        }
        return hints;
    }

    protected String sessionAttributeFor(Bookmark bookmark) {
        return "hint-" + bookmark.stringifyHonoringHintIfAny();
    }
}

