/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.wicketapp;

import java.security.SecureRandom;
import java.util.OptionalLong;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.causeway.commons.internal.os._OsUtil;
import org.apache.wicket.core.random.DefaultSecureRandomSupplier;
import org.apache.wicket.core.random.ISecureRandomSupplier;
import org.apache.wicket.core.util.crypt.AESCrypt;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.NoCrypt;
import org.apache.wicket.util.crypt.SunJceCrypt;

final class _CryptFactory {
    static final String FIXED_SALT_FOR_PROTOTYPING = "PrototypingEncryptionKey";

    static ICrypt sunJceCrypt(String encryptionKey) {
        byte[] salt = _CryptFactory.getSalt(8, encryptionKey);
        SunJceCrypt crypt = new SunJceCrypt(salt, 1000);
        crypt.setKey(encryptionKey);
        return crypt;
    }

    static ICrypt aesCrypt(String encryptionKey) {
        byte[] salt = _CryptFactory.getSalt(8, encryptionKey);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(encryptionKey.toCharArray(), salt, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        DefaultSecureRandomSupplier rGen = new DefaultSecureRandomSupplier();
        return new AESCrypt((SecretKey)secret, (ISecureRandomSupplier)rGen);
    }

    static ICrypt noCrypt(String encryptionKey) {
        return new NoCrypt();
    }

    private static byte[] getSalt(int size, String encryptionKey) {
        byte[] salt = FIXED_SALT_FOR_PROTOTYPING.equals(encryptionKey) ? _CryptFactory.machineFixedSalt(size) : _CryptFactory.secureSalt(size);
        return salt;
    }

    private static byte[] secureSalt(int size) {
        byte[] salt = new byte[size];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    private static byte[] machineFixedSalt(int size) {
        OptionalLong machineFixedSeed = _OsUtil.machineId();
        if (machineFixedSeed.isEmpty()) {
            return _CryptFactory.secureSalt(size);
        }
        byte[] salt = new byte[size];
        new Random(machineFixedSeed.getAsLong()).nextBytes(salt);
        return salt;
    }

    @Generated
    private _CryptFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

