/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.codahale;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.codahale.CodahaleMetricsContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;

@NoJSR250Annotations
public class CodahaleMetricsProvider
implements MetricsProvider {
    private static final String QUESTION_MARK = "?";
    private static final String ESCAPED_QUESTION_MARK = "\\?";
    protected Bus bus;
    protected MetricRegistry registry;

    public CodahaleMetricsProvider(Bus b) {
        this.bus = b;
        this.registry = (MetricRegistry)b.getExtension(MetricRegistry.class);
        this.bus = b;
        if (this.registry == null) {
            this.registry = new MetricRegistry();
            CodahaleMetricsProvider.setupJMXReporter(b, this.registry);
        }
    }

    public static void setupJMXReporter(Bus b, MetricRegistry reg) {
        InstrumentationManager im = (InstrumentationManager)b.getExtension(InstrumentationManager.class);
        if (im != null) {
            JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)reg).registerWith(im.getMBeanServer()).inDomain("org.apache.cxf").createsObjectNamesWith(new ObjectNameFactory(){

                public ObjectName createName(String type, String domain, String name) {
                    try {
                        return new ObjectName(name);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).build();
            reporter.start();
        }
    }

    protected String escapePatternChars(String value) {
        if (value.lastIndexOf(QUESTION_MARK) != -1) {
            value = value.replace(QUESTION_MARK, ESCAPED_QUESTION_MARK);
        }
        return value;
    }

    StringBuilder getBaseServiceName(Endpoint endpoint, boolean isClient, String clientId) {
        StringBuilder buffer = new StringBuilder();
        if (endpoint.get((Object)"org.apache.cxf.management.service.counter.name") != null) {
            buffer.append((String)endpoint.get((Object)"org.apache.cxf.management.service.counter.name"));
        } else {
            Service service = endpoint.getService();
            String serviceName = "\"" + this.escapePatternChars(service.getName().toString()) + "\"";
            String portName = "\"" + endpoint.getEndpointInfo().getName().getLocalPart() + "\"";
            buffer.append("org.apache.cxf").append(':');
            buffer.append("bus.id=" + this.bus.getId() + ",");
            buffer.append("type").append("=Metrics");
            if (isClient) {
                buffer.append(".Client,");
            } else {
                buffer.append(".Server,");
            }
            buffer.append("service=" + serviceName + ",");
            buffer.append("port=" + portName + ",");
            if (clientId != null) {
                buffer.append("Client=" + clientId + ",");
            }
        }
        return buffer;
    }

    @Override
    public MetricsContext createEndpointContext(Endpoint endpoint, boolean isClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, isClient, clientId);
        String baseName = buffer.toString();
        return new CodahaleMetricsContext(baseName, this.registry);
    }

    @Override
    public MetricsContext createOperationContext(Endpoint endpoint, BindingOperationInfo boi, boolean asClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, asClient, clientId);
        buffer.append("Operation=").append(boi.getName().getLocalPart()).append(',');
        return new CodahaleMetricsContext(buffer.toString(), this.registry);
    }

    @Override
    public MetricsContext createResourceContext(Endpoint endpoint, String resourceName, boolean asClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, asClient, clientId);
        buffer.append("Operation=").append(resourceName).append(',');
        return new CodahaleMetricsContext(buffer.toString(), this.registry);
    }
}

