/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class MacAccessToken
extends ServerAccessToken {
    public MacAccessToken(Client client, long lifetime) {
        this(client, HmacAlgorithm.HmacSHA256, lifetime);
    }

    public MacAccessToken(Client client, String macAuthAlgo, long lifetime) {
        this(client, HmacAlgorithm.toHmacAlgorithm(macAuthAlgo), lifetime);
    }

    public MacAccessToken(Client client, HmacAlgorithm macAlgo, long lifetime) {
        this(client, macAlgo, OAuthUtils.generateRandomTokenKey(), lifetime, System.currentTimeMillis() / 1000L);
    }

    public MacAccessToken(Client client, HmacAlgorithm algo, String tokenKey, long lifetime, long issuedAt) {
        super(client, "mac", tokenKey, lifetime, issuedAt);
        this.setExtraParameters(algo, null);
    }

    public MacAccessToken(Client client, HmacAlgorithm algo, String tokenKey, String macKey, long lifetime, long issuedAt) {
        super(client, "mac", tokenKey, lifetime, issuedAt);
        this.setExtraParameters(algo, macKey);
    }

    private void setExtraParameters(HmacAlgorithm algo, String macKey) {
        String theKey = macKey == null ? HmacUtils.generateSecret(algo) : macKey;
        super.getParameters().put("mac_key", theKey);
        super.getParameters().put("mac_algorithm", algo.getOAuthName());
    }

    public String getMacId() {
        return super.getTokenKey();
    }

    public String getMacKey() {
        return super.getParameters().get("mac_key");
    }

    public String getMacAlgorithm() {
        return super.getParameters().get("mac_algorithm");
    }
}

