/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.policyvalidators.IssuedTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.WSSecurityUtil;

public class IssuedTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    public IssuedTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN));
        this.getOutInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getOutInterceptors().add(new IssuedTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new IssuedTokenOutInterceptor());
        this.getInInterceptors().add(new IssuedTokenInInterceptor());
        this.getInFaultInterceptors().add(new IssuedTokenInInterceptor());
    }

    static final TokenStore getTokenStore(Message message) {
        TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
        if (tokenStore == null) {
            tokenStore = new MemoryTokenStore();
            ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)tokenStore);
        }
        return tokenStore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssuedTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
                if (ais == null) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                    if (results != null) {
                        this.parseHandlerResults(results, message, aim);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void parseHandlerResults(List<WSHandlerResult> results, Message message, AssertionInfoMap aim) {
            if (results != null) {
                for (WSHandlerResult rResult : results) {
                    WSSecurityEngineResult wser = this.findSecurityResult(rResult.getResults());
                    if (wser == null) continue;
                    ArrayList<WSSecurityEngineResult> signedResults = new ArrayList<WSSecurityEngineResult>();
                    WSSecurityUtil.fetchAllActionResults((List)rResult.getResults(), (int)2, signedResults);
                    IssuedTokenPolicyValidator issuedValidator = new IssuedTokenPolicyValidator(signedResults, message);
                    if (!issuedValidator.validatePolicy(aim, wser)) break;
                    SecurityToken token = this.createSecurityToken(wser);
                    message.getExchange().put((Object)"ws-security.token", (Object)token);
                }
            }
        }

        private WSSecurityEngineResult findSecurityResult(List<WSSecurityEngineResult> wsSecEngineResults) {
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                AssertionWrapper assertionWrapper;
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 16 || (assertionWrapper = (AssertionWrapper)wser.get((Object)"saml-assertion")).getSubjectKeyInfo() == null) continue;
                return wser;
            }
            return null;
        }

        private SecurityToken createSecurityToken(WSSecurityEngineResult wser) {
            AssertionWrapper assertionWrapper = (AssertionWrapper)wser.get((Object)"saml-assertion");
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            SecurityToken token = new SecurityToken(assertionWrapper.getId());
            token.setSecret(subjectKeyInfo.getSecret());
            X509Certificate[] certs = subjectKeyInfo.getCerts();
            if (certs != null && certs.length > 0) {
                token.setX509Certificate(certs[0], null);
            }
            if (assertionWrapper.getSaml1() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (assertionWrapper.getSaml2() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            return token;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssuedTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenOutInterceptor() {
            super("prepare-send");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    String tokId;
                    IssuedToken itok = (IssuedToken)((AssertionInfo)ais.iterator().next()).getAssertion();
                    SecurityToken tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                    if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                        tok = IssuedTokenInterceptorProvider.getTokenStore(message).getToken(tokId);
                    }
                    if (tok == null) {
                        STSClient client = STSUtils.getClient(message, "sts");
                        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
                        if (maps == null) {
                            maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
                        }
                        STSClient sTSClient = client;
                        synchronized (sTSClient) {
                            try {
                                client.setActAs(message.getContextualProperty("ws-security.sts.token.act-as"));
                                client.setTrust(this.getTrust10(aim));
                                client.setTrust(this.getTrust13(aim));
                                client.setTemplate(itok.getRstTemplate());
                                if (maps == null) {
                                    tok = client.requestSecurityToken();
                                } else {
                                    Object o = message.getContextualProperty("ws-security.sts.applies-to");
                                    String s = o == null ? null : o.toString();
                                    s = s == null ? message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString() : s;
                                    client.setAddressingNamespace(maps.getNamespaceURI());
                                    tok = client.requestSecurityToken(s);
                                }
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new Fault((Throwable)e);
                            }
                            finally {
                                client.setTrust((Trust10)null);
                                client.setTrust((Trust13)null);
                                client.setTemplate(null);
                                client.setAddressingNamespace(null);
                            }
                        }
                    }
                    if (tok != null) {
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                        message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                        IssuedTokenInterceptorProvider.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private Trust10 getTrust10(AssertionInfoMap aim) {
            Collection ais = (Collection)aim.get((Object)SP11Constants.TRUST_10);
            if (ais == null || ais.isEmpty()) {
                return null;
            }
            return (Trust10)((AssertionInfo)ais.iterator().next()).getAssertion();
        }

        private Trust13 getTrust13(AssertionInfoMap aim) {
            Collection ais = (Collection)aim.get((Object)SP12Constants.TRUST_13);
            if (ais == null || ais.isEmpty()) {
                return null;
            }
            return (Trust13)((AssertionInfo)ais.iterator().next()).getAssertion();
        }
    }
}

