/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTokenInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSoapInterceptor.class);
    private static final Set<QName> HEADERS = Collections.singleton(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));

    public AbstractTokenInterceptor() {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JOutInterceptor.class.getName());
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        boolean isOut;
        boolean isReq = MessageUtils.isRequestor((Message)message);
        if (isReq != (isOut = MessageUtils.isOutbound((Message)message))) {
            this.assertTokens(message);
            return;
        }
        if (isReq) {
            if (message.containsKey((Object)PolicyBasedWSS4JOutInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.addToken(message);
        } else {
            if (message.containsKey((Object)WSS4JInInterceptor.SECURITY_PROCESSED)) {
                return;
            }
            this.processToken(message);
        }
    }

    protected abstract void processToken(SoapMessage var1);

    protected abstract void addToken(SoapMessage var1);

    protected abstract Token assertTokens(SoapMessage var1);

    protected Token assertTokens(SoapMessage message, QName assertion, boolean signed) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(assertion);
        Token tok = null;
        for (AssertionInfo ai : ais) {
            tok = (Token)ai.getAssertion();
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        if (signed || this.isTLSInUse(message)) {
            ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
        return tok;
    }

    protected boolean isTLSInUse(SoapMessage message) {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        return tlsInfo != null;
    }

    protected CallbackHandler getCallback(SoapMessage message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenStore getTokenStore(SoapMessage message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty(TokenStore.class.getName());
            }
            return tokenStore;
        }
    }

    protected Header findSecurityHeader(SoapMessage message, boolean create) {
        for (Header h : message.getHeaders()) {
            QName n = h.getName();
            if (!n.getLocalPart().equals("Security") || !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
            return h;
        }
        if (!create) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SoapHeader sh = new SoapHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), (Object)el);
        sh.setMustUnderstand(true);
        message.getHeaders().add(sh);
        return sh;
    }

    protected String getPassword(String userName, Token info, int type, SoapMessage message) {
        CallbackHandler handler = this.getCallback(message);
        if (handler == null) {
            this.policyNotAsserted(info, "No callback handler and no password available", message);
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            this.policyNotAsserted(info, e, message);
        }
        return cb[0].getPassword();
    }

    protected void policyNotAsserted(Token assertion, String reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get((Object)assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason);
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new org.apache.cxf.common.i18n.Message(reason, LOG, new Object[0]));
        }
    }

    protected void policyNotAsserted(Token assertion, Exception reason, SoapMessage message) {
        if (assertion == null) {
            return;
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = (Collection)aim.get((Object)assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason.getMessage());
            }
        }
        throw new PolicyException((Throwable)reason);
    }
}

