/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.tools.xjc.ErrorReceiver;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXParseException;

public class XJCErrorListener
extends ErrorReceiver {
    private BuildContext buildContext;
    private final List<File> errorfiles = new ArrayList<File>();
    private Exception firstError;

    public XJCErrorListener(BuildContext context) {
        this.buildContext = context;
    }

    public Exception getFirstError() {
        return this.firstError;
    }

    public void error(Exception exception) {
        if (this.firstError == null) {
            this.firstError = exception;
            this.firstError.fillInStackTrace();
        }
    }

    public void error(SAXParseException exception) {
        String sysId = exception.getSystemId();
        File file = this.mapFile(sysId);
        if (file != null && !this.errorfiles.contains(file)) {
            this.buildContext.removeMessages(file);
            this.errorfiles.add(file);
        }
        this.buildContext.addMessage(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), 2, (Throwable)exception);
        if (this.firstError == null) {
            this.firstError = exception;
            this.firstError.fillInStackTrace();
        }
    }

    private String mapMessage(String localizedMessage) {
        return localizedMessage;
    }

    private File mapFile(String s) {
        File file = null;
        if (s != null && s.startsWith("file:")) {
            if (s.contains("#")) {
                s = s.substring(0, s.indexOf(35));
            }
            try {
                URI uri = new URI(s);
                file = new File(uri);
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if (file == null) {
            if (s == null) {
                file = new File("null");
            } else {
                final String s2 = s;
                file = new File(this, s2){
                    private static final long serialVersionUID = 1L;
                    final /* synthetic */ XJCErrorListener this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public String getAbsolutePath() {
                        return s2;
                    }
                };
            }
        }
        return file;
    }

    public void fatalError(SAXParseException exception) {
        this.error(exception);
        if (this.firstError == null) {
            this.firstError = exception;
            this.firstError.fillInStackTrace();
        }
    }

    public void warning(SAXParseException exception) {
        File file = this.mapFile(exception.getSystemId());
        if (file != null && !this.errorfiles.contains(file)) {
            this.buildContext.removeMessages(file);
            this.errorfiles.add(file);
        }
        this.buildContext.addMessage(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), 1, (Throwable)exception);
    }

    public void info(SAXParseException exception) {
    }

    public void message(File file, String string) {
        this.buildContext.addMessage(file, 0, 0, this.mapMessage(string), 2, null);
    }

    public void warning(File file, Exception e) {
        this.buildContext.addMessage(file, 0, 0, this.mapMessage(e.getLocalizedMessage()), 1, (Throwable)e);
    }
}

