/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(BooleanComparator.class);

    public BooleanComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String b1, String b2) {
        boolean boolean2;
        LOG.debug("comparing boolean objects '{}' with '{}'", (Object)b1, (Object)b2);
        if (b1 == b2) {
            return 0;
        }
        if (b1 == null || b2 == null) {
            return b1 == null ? -1 : 1;
        }
        boolean boolean1 = Boolean.parseBoolean(b1);
        if (boolean1 == (boolean2 = Boolean.parseBoolean(b2))) {
            return 0;
        }
        return boolean1 ? 1 : -1;
    }
}

