/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.callback;

import java.io.IOException;
import java.text.MessageFormat;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.apache.directory.ldap.client.api.SaslRequest;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCallbackHandler
implements CallbackHandler {
    private SaslRequest saslReq;
    private static final Logger LOG = LoggerFactory.getLogger(SaslCallbackHandler.class);

    public SaslCallbackHandler(SaslRequest saslReq) {
        this.saslReq = saslReq;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                NameCallback ncb = (NameCallback)cb;
                String name = this.saslReq.getUsername();
                LOG.debug("sending name {} in the NameCallback", (Object)name);
                ncb.setName(name);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)cb;
                LOG.debug("sending credentials in the PasswordCallback");
                pcb.setPassword(Strings.utf8ToString(this.saslReq.getCredentials()).toCharArray());
                continue;
            }
            if (cb instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)cb;
                if (this.saslReq.getRealmName() != null) {
                    LOG.debug("sending the user specified realm value {} in the RealmCallback", (Object)this.saslReq.getRealmName());
                    rcb.setText(this.saslReq.getRealmName());
                    continue;
                }
                LOG.debug("No user specified relam value, sending the default realm value {} in the RealmCallback", (Object)rcb.getDefaultText());
                rcb.setText(rcb.getDefaultText());
                continue;
            }
            if (!(cb instanceof RealmChoiceCallback)) continue;
            RealmChoiceCallback rccb = (RealmChoiceCallback)cb;
            boolean foundRealmName = false;
            String[] realmNames = rccb.getChoices();
            for (int i = 0; i < realmNames.length; ++i) {
                String realmName = realmNames[i];
                if (!realmName.equals(this.saslReq.getRealmName())) continue;
                foundRealmName = true;
                LOG.debug("sending the user specified realm value {} in the RealmChoiceCallback", (Object)realmName);
                rccb.setSelectedIndex(i);
                break;
            }
            if (foundRealmName) continue;
            throw new IOException(MessageFormat.format("Cannot match ''java.naming.security.sasl.realm'' property value ''{0}'' with choices ''{1}'' in RealmChoiceCallback.", this.saslReq.getRealmName(), this.getRealmNamesAsString(realmNames)));
        }
    }

    private String getRealmNamesAsString(String[] realmNames) {
        StringBuilder sb = new StringBuilder();
        if (realmNames != null && realmNames.length > 0) {
            for (String realmName : realmNames) {
                sb.append(realmName);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

