/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.util.Base64;
import org.apache.directory.shared.util.Strings;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserUtils {
    public static final String XML_SCHEMA_URI = "http://www.w3c.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3c.org/2001/XMLSchema-instance";
    public static final String BASE64BINARY = "base64Binary";
    public static final String XSI = "xsi";
    public static final String XSD = "xsd";
    public static final Namespace DSML_NAMESPACE = new Namespace(null, "urn:oasis:names:tc:DSML:2:0:core");
    public static final Namespace XSD_NAMESPACE = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
    public static final Namespace XSI_NAMESPACE = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");

    private ParserUtils() {
    }

    public static String getXsiTypeAttributeValue(XmlPullParser xpp) {
        String type = null;
        int nbAttributes = xpp.getAttributeCount();
        for (int i = 0; i < nbAttributes; ++i) {
            if (!xpp.getAttributeName(i).equals("type") || !xpp.getNamespace(xpp.getAttributePrefix(i)).equals(XML_SCHEMA_INSTANCE_URI)) continue;
            type = xpp.getAttributeValue(i);
            break;
        }
        return type;
    }

    public static boolean isBase64BinaryValue(XmlPullParser parser, String attrValue) {
        if (attrValue == null) {
            return false;
        }
        String[] splitedString = attrValue.split(":");
        return splitedString.length == 2 && XML_SCHEMA_URI.equals(parser.getNamespace(splitedString[0])) && BASE64BINARY.equals(splitedString[1]);
    }

    public static boolean needsBase64Encoding(Object value) {
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof String) {
            return !LdifUtils.isLDIFSafe((String)value);
        }
        return true;
    }

    public static String base64Encode(Object value) {
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])value));
        }
        if (value instanceof String) {
            return new String(Base64.encode(Strings.getBytesUtf8((String)value)));
        }
        return "";
    }

    public static int parseAndVerifyRequestID(String attributeValue, XmlPullParser xpp) throws XmlPullParserException {
        try {
            int requestID = Integer.parseInt(attributeValue);
            if (requestID == 0) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03038, new Object[0]), xpp, null);
            }
            return requestID;
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03039, new Object[0]), xpp, null);
        }
    }

    public static void addControls(LdapApiService codec, Element element, Collection<Control> controls) {
        if (controls != null) {
            for (Control control : controls) {
                byte[] value;
                Element controlElement = element.addElement("control");
                if (control.getOid() != null) {
                    controlElement.addAttribute("type", control.getOid());
                }
                if (control.isCritical()) {
                    controlElement.addAttribute("criticality", "true");
                }
                if ((value = control instanceof CodecControl ? ((CodecControl)control).getValue() : codec.newControl(control).getValue()) == null) continue;
                if (ParserUtils.needsBase64Encoding(value)) {
                    element.getDocument().getRootElement().add(XSD_NAMESPACE);
                    element.getDocument().getRootElement().add(XSI_NAMESPACE);
                    Element valueElement = controlElement.addElement("controlValue").addText(ParserUtils.base64Encode(value));
                    valueElement.addAttribute(new QName("type", XSI_NAMESPACE), "xsd:base64Binary");
                    continue;
                }
                controlElement.addElement("controlValue").setText(Arrays.toString(value));
            }
        }
    }

    public static boolean isRequestIdNeeded(Dsmlv2Container container) throws XmlPullParserException {
        BatchRequestDsml batchRequest = container.getBatchRequest();
        if (batchRequest == null) {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03040, new Object[0]), container.getParser(), null);
        }
        return batchRequest.getProcessing() == BatchRequestDsml.Processing.PARALLEL && batchRequest.getResponseOrder() == BatchRequestDsml.ResponseOrder.UNORDERED;
    }

    public static Document styleDocument(Document document) {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer(new StreamSource(ParserUtils.class.getResourceAsStream("DSMLv2.xslt")));
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
            return document;
        }
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        try {
            transformer.transform((Source)source, (Result)result);
        }
        catch (TransformerException e) {
            return document;
        }
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }
}

