/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.util.Oid;
import org.apache.directory.shared.dsmlv2.AbstractGrammar;
import org.apache.directory.shared.dsmlv2.DsmlControl;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.shared.dsmlv2.Grammar;
import org.apache.directory.shared.dsmlv2.GrammarAction;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.dsmlv2.request.AbandonRequestDsml;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.dsmlv2.request.AddRequestDsml;
import org.apache.directory.shared.dsmlv2.request.AndFilter;
import org.apache.directory.shared.dsmlv2.request.AttributeValueAssertion;
import org.apache.directory.shared.dsmlv2.request.AttributeValueAssertionFilter;
import org.apache.directory.shared.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.shared.dsmlv2.request.BindRequestDsml;
import org.apache.directory.shared.dsmlv2.request.CompareRequestDsml;
import org.apache.directory.shared.dsmlv2.request.DelRequestDsml;
import org.apache.directory.shared.dsmlv2.request.ExtendedRequestDsml;
import org.apache.directory.shared.dsmlv2.request.ExtensibleMatchFilter;
import org.apache.directory.shared.dsmlv2.request.Filter;
import org.apache.directory.shared.dsmlv2.request.ModifyDNRequestDsml;
import org.apache.directory.shared.dsmlv2.request.ModifyRequestDsml;
import org.apache.directory.shared.dsmlv2.request.NotFilter;
import org.apache.directory.shared.dsmlv2.request.OrFilter;
import org.apache.directory.shared.dsmlv2.request.PresentFilter;
import org.apache.directory.shared.dsmlv2.request.SearchRequestDsml;
import org.apache.directory.shared.dsmlv2.request.SubstringFilter;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddRequestImpl;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.Request;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.util.Base64;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Dsmlv2Grammar
extends AbstractGrammar
implements Grammar {
    private LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private final GrammarAction batchRequestCreation = new GrammarAction("Create Batch Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BatchRequestDsml batchRequest = new BatchRequestDsml();
            container.setBatchRequest(batchRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                batchRequest.setRequestID(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "processing")) != null) {
                if ("sequential".equals(attributeValue)) {
                    batchRequest.setProcessing(BatchRequestDsml.Processing.SEQUENTIAL);
                } else {
                    if (!"parallel".equals(attributeValue)) throw new XmlPullParserException(I18n.err(I18n.ERR_03013, new Object[0]), xpp, null);
                    batchRequest.setProcessing(BatchRequestDsml.Processing.PARALLEL);
                }
            } else {
                batchRequest.setProcessing(BatchRequestDsml.Processing.SEQUENTIAL);
            }
            attributeValue = xpp.getAttributeValue("", "onError");
            if (attributeValue != null) {
                if ("resume".equals(attributeValue)) {
                    batchRequest.setOnError(BatchRequestDsml.OnError.RESUME);
                } else {
                    if (!"exit".equals(attributeValue)) throw new XmlPullParserException(I18n.err(I18n.ERR_03014, new Object[0]), xpp, null);
                    batchRequest.setOnError(BatchRequestDsml.OnError.EXIT);
                }
            } else {
                batchRequest.setOnError(BatchRequestDsml.OnError.EXIT);
            }
            attributeValue = xpp.getAttributeValue("", "responseOrder");
            if (attributeValue != null) {
                if ("sequential".equals(attributeValue)) {
                    batchRequest.setResponseOrder(BatchRequestDsml.ResponseOrder.SEQUENTIAL);
                    return;
                } else {
                    if (!"unordered".equals(attributeValue)) throw new XmlPullParserException(I18n.err(I18n.ERR_03015, new Object[0]), xpp, null);
                    batchRequest.setResponseOrder(BatchRequestDsml.ResponseOrder.UNORDERED);
                }
                return;
            } else {
                batchRequest.setResponseOrder(BatchRequestDsml.ResponseOrder.SEQUENTIAL);
            }
        }
    };
    private final GrammarAction abandonRequestCreation = new GrammarAction("Create Abandon Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AbandonRequestDsml abandonRequest = new AbandonRequestDsml(Dsmlv2Grammar.this.codec, new AbandonRequestImpl());
            container.getBatchRequest().addRequest(abandonRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                abandonRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "abandonID");
            if (attributeValue != null) {
                try {
                    abandonRequest.setAbandoned(Integer.parseInt(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03017, new Object[0]), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03018, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestCreation = new GrammarAction("Create Add Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddRequestDsml addRequest = new AddRequestDsml(Dsmlv2Grammar.this.codec, new AddRequestImpl());
            container.getBatchRequest().addRequest(addRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                addRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    addRequest.setEntryDn(new Dn(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03019, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestAddAttribute = new GrammarAction("Add Attribute to Add Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddRequestDsml addRequest = (AddRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue != null) {
                try {
                    addRequest.addAttributeType(attributeValue);
                }
                catch (LdapException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03020, new Object[0]), xpp, (Throwable)e);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestAddValue = new GrammarAction("Add Value to Attribute"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            block6: {
                AddRequestDsml addRequest = (AddRequestDsml)container.getBatchRequest().getCurrentRequest();
                XmlPullParser xpp = container.getParser();
                try {
                    String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                    String nextText = xpp.nextText();
                    if (nextText.equals("")) break block6;
                    try {
                        if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                            addRequest.addAttributeValue(Base64.decode(nextText.trim().toCharArray()));
                        } else {
                            addRequest.addAttributeValue(nextText.trim());
                        }
                    }
                    catch (LdapException le) {
                        throw new XmlPullParserException(le.getMessage());
                    }
                }
                catch (IOException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
                }
            }
        }
    };
    private final GrammarAction authRequestCreation = new GrammarAction("Create Auth Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BindRequestDsml authRequest = new BindRequestDsml(Dsmlv2Grammar.this.codec, new BindRequestImpl());
            container.getBatchRequest().addRequest(authRequest);
            authRequest.setSimple(true);
            authRequest.setVersion3(true);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                authRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "principal");
            if (attributeValue != null) {
                try {
                    authRequest.setName(new Dn(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03021, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction compareRequestCreation = new GrammarAction("Create Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequestDsml compareRequest = new CompareRequestDsml(Dsmlv2Grammar.this.codec, new CompareRequestImpl());
            container.getBatchRequest().addRequest(compareRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                compareRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    compareRequest.setName(new Dn(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03019, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction compareRequestAddAssertion = new GrammarAction("Add Assertion to Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequest compareRequest = (CompareRequest)((Object)container.getBatchRequest().getCurrentRequest());
            XmlPullParser xpp = container.getParser();
            String attributeId = xpp.getAttributeValue("", "name");
            if (attributeId == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            compareRequest.setAttributeId(attributeId);
        }
    };
    private final GrammarAction compareRequestAddValue = new GrammarAction("Add Value to Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequest compareRequest = (CompareRequest)((Object)container.getBatchRequest().getCurrentRequest());
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        compareRequest.setAssertionValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        compareRequest.setAssertionValue(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction delRequestCreation = new GrammarAction("Create Del Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DelRequestDsml delRequest = new DelRequestDsml(Dsmlv2Grammar.this.codec, new DeleteRequestImpl());
            container.getBatchRequest().addRequest(delRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                delRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    delRequest.setName(new Dn(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03019, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestCreation = new GrammarAction("Create Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestDsml extendedRequest = new ExtendedRequestDsml(Dsmlv2Grammar.this.codec, new ExtendedRequestImpl());
            container.getBatchRequest().addRequest(extendedRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                extendedRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestAddName = new GrammarAction("Add Name to Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestDsml extendedRequest = (ExtendedRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (nextText.equals("")) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03022, new Object[0]), xpp, null);
                }
                String oid = nextText.trim();
                if (!Oid.isOid(oid)) {
                    throw new XmlPullParserException("Bad oid : " + oid, xpp, null);
                }
                extendedRequest.setRequestName(nextText.trim());
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestAddValue = new GrammarAction("Add Value to Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestDsml extendedRequest = (ExtendedRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        extendedRequest.setRequestValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        extendedRequest.setRequestValue(nextText.trim().getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction modDNRequestCreation = new GrammarAction("Create Modify Dn Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyDNRequestDsml modifyDNRequest = new ModifyDNRequestDsml(Dsmlv2Grammar.this.codec, new ModifyDnRequestImpl());
            container.getBatchRequest().addRequest(modifyDNRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyDNRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03019, new Object[0]), xpp, null);
            try {
                modifyDNRequest.setName(new Dn(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "newrdn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03023, new Object[0]), xpp, null);
            try {
                modifyDNRequest.setNewRdn(new Rdn(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "deleteoldrdn");
            if (attributeValue != null) {
                if (attributeValue.equalsIgnoreCase("true") || attributeValue.equals("1")) {
                    modifyDNRequest.setDeleteOldRdn(true);
                } else {
                    if (!attributeValue.equalsIgnoreCase("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err(I18n.ERR_03024, new Object[0]), xpp, null);
                    modifyDNRequest.setDeleteOldRdn(false);
                }
            } else {
                modifyDNRequest.setDeleteOldRdn(true);
            }
            attributeValue = xpp.getAttributeValue("", "newSuperior");
            if (attributeValue == null) return;
            try {
                modifyDNRequest.setNewSuperior(new Dn(attributeValue));
                return;
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction modifyRequestCreation = new GrammarAction("Create Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestDsml modifyRequest = new ModifyRequestDsml(Dsmlv2Grammar.this.codec, new ModifyRequestImpl());
            container.getBatchRequest().addRequest(modifyRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    modifyRequest.setName(new Dn(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getLocalizedMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException("dn attribute is required", xpp, null);
            }
        }
    };
    private final GrammarAction modifyRequestAddModification = new GrammarAction("Adds Modification to Modify Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestDsml modifyRequest = (ModifyRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "operation");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03025, new Object[0]), xpp, null);
            if ("add".equals(attributeValue)) {
                modifyRequest.setCurrentOperation(0);
            } else if ("delete".equals(attributeValue)) {
                modifyRequest.setCurrentOperation(1);
            } else {
                if (!"replace".equals(attributeValue)) throw new XmlPullParserException("unknown operation. Operation can be 'add', 'delete' or 'replace'.", xpp, null);
                modifyRequest.setCurrentOperation(2);
            }
            attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            modifyRequest.addAttributeTypeAndValues(attributeValue);
        }
    };
    private final GrammarAction modifyRequestAddValue = new GrammarAction("Add Value to Modification of Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestDsml modifyRequest = (ModifyRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                try {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        modifyRequest.addAttributeValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        modifyRequest.addAttributeValue(nextText.trim());
                    }
                }
                catch (LdapException le) {
                    throw new XmlPullParserException(le.getMessage());
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction searchRequestCreation = new GrammarAction("Create Search Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequest = new SearchRequestDsml(Dsmlv2Grammar.this.codec, new SearchRequestImpl());
            container.getBatchRequest().addRequest(searchRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03016, new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03019, new Object[0]), xpp, null);
            try {
                searchRequest.setBase(new Dn(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "scope");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03027, new Object[0]), xpp, null);
            if ("baseObject".equals(attributeValue)) {
                searchRequest.setScope(SearchScope.OBJECT);
            } else if ("singleLevel".equals(attributeValue)) {
                searchRequest.setScope(SearchScope.ONELEVEL);
            } else {
                if (!"wholeSubtree".equals(attributeValue)) throw new XmlPullParserException(I18n.err(I18n.ERR_03026, new Object[0]), xpp, null);
                searchRequest.setScope(SearchScope.SUBTREE);
            }
            attributeValue = xpp.getAttributeValue("", "derefAliases");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err(I18n.ERR_03029, new Object[0]), xpp, null);
            if ("neverDerefAliases".equals(attributeValue)) {
                searchRequest.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            } else if ("derefInSearching".equals(attributeValue)) {
                searchRequest.setDerefAliases(AliasDerefMode.DEREF_IN_SEARCHING);
            } else if ("derefFindingBaseObj".equals(attributeValue)) {
                searchRequest.setDerefAliases(AliasDerefMode.DEREF_FINDING_BASE_OBJ);
            } else {
                if (!"derefAlways".equals(attributeValue)) throw new XmlPullParserException(I18n.err(I18n.ERR_03028, new Object[0]), xpp, null);
                searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            }
            attributeValue = xpp.getAttributeValue("", "sizeLimit");
            if (attributeValue != null) {
                try {
                    searchRequest.setSizeLimit(Long.parseLong(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03030, new Object[0]), xpp, null);
                }
            } else {
                searchRequest.setSizeLimit(0L);
            }
            attributeValue = xpp.getAttributeValue("", "timeLimit");
            if (attributeValue != null) {
                try {
                    searchRequest.setTimeLimit(Integer.parseInt(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03031, new Object[0]), xpp, null);
                }
            } else {
                searchRequest.setTimeLimit(0);
            }
            attributeValue = xpp.getAttributeValue("", "typesOnly");
            if (attributeValue != null) {
                if (attributeValue.equals("true") || attributeValue.equals("1")) {
                    searchRequest.setTypesOnly(true);
                    return;
                } else {
                    if (!attributeValue.equals("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err(I18n.ERR_03032, new Object[0]), xpp, null);
                    searchRequest.setTypesOnly(false);
                }
                return;
            } else {
                searchRequest.setTypesOnly(false);
            }
        }
    };
    private final GrammarAction searchRequestAddAttribute = new GrammarAction("Add Value to Modification of Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequest searchRequest = (SearchRequest)((Object)container.getBatchRequest().getCurrentRequest());
            XmlPullParser xpp = container.getParser();
            String attributeName = xpp.getAttributeValue("", "name");
            if (attributeName == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            searchRequest.addAttributes(attributeName);
        }
    };
    private final GrammarAction substringsFilterCreation = new GrammarAction("Create Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            SubstringFilter filter = new SubstringFilter();
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(filter);
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            filter.setType(attributeValue);
        }
    };
    private final GrammarAction substringsFilterSetInitial = new GrammarAction("Set Initial value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.setInitialSubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.setInitialSubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterAddAny = new GrammarAction("Add Any value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.addAnySubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.addAnySubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterSetFinal = new GrammarAction("Set Final value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.setFinalSubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.setFinalSubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterClose = new GrammarAction("Close Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            searchRequestDecorator.setTerminalFilter(null);
        }
    };
    private final GrammarAction andFilterCreation = new GrammarAction("Create And Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AndFilter filter = new AndFilter();
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction connectorFilterClose = new GrammarAction("Close Connector Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            Filter filter = searchRequestDecorator.getCurrentFilter();
            searchRequestDecorator.setCurrentFilter(filter);
        }
    };
    private final GrammarAction orFilterCreation = new GrammarAction("Create Or Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            OrFilter filter = new OrFilter();
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction notFilterCreation = new GrammarAction("Create Not Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            NotFilter filter = new NotFilter();
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction equalityMatchFilterCreation = new GrammarAction("Create Equality Match Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeName = xpp.getAttributeValue("", "name");
            if (attributeName == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(attributeName);
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(0);
            filter.setAssertion(assertion);
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(filter);
        }
    };
    private final GrammarAction greaterOrEqualFilterCreation = new GrammarAction("Create Greater Or Equal Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeName = xpp.getAttributeValue("", "name");
            if (attributeName == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(attributeName);
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(1);
            filter.setAssertion(assertion);
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(filter);
        }
    };
    private final GrammarAction lessOrEqualFilterCreation = new GrammarAction("Create Less Or Equal Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(new String(attributeValue.getBytes()));
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(2);
            filter.setAssertion(assertion);
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(filter);
        }
    };
    private final GrammarAction approxMatchFilterCreation = new GrammarAction("Create Approx Match Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeName = xpp.getAttributeValue("", "name");
            if (attributeName == null) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(attributeName);
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(3);
            filter.setAssertion(assertion);
            try {
                searchRequestDecorator.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(filter);
        }
    };
    private final GrammarAction filterAddValue = new GrammarAction("Adds Value to Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            AttributeValueAssertionFilter filter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
            AttributeValueAssertion assertion = filter.getAssertion();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        BinaryValue value = new BinaryValue(Base64.decode(nextText.trim().toCharArray()));
                        assertion.setAssertionValue(value);
                    } else {
                        StringValue value = new StringValue(nextText.trim());
                        assertion.setAssertionValue(value);
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction presentFilterCreation = new GrammarAction("Create Present Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            PresentFilter presentFilter = new PresentFilter();
            XmlPullParser xpp = container.getParser();
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            try {
                searchRequestDecorator.addCurrentFilter(presentFilter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException("name attribute is required", xpp, null);
            }
            presentFilter.setAttributeDescription(new String(attributeValue.getBytes()));
        }
    };
    private final GrammarAction storeFilter = new GrammarAction("Store Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            SearchRequest searchRequest = (SearchRequest)searchRequestDecorator.getDecorated();
            if (searchRequestDecorator.getFilterNode() == null) {
                throw new IllegalStateException("No filter element present in the DSML search request");
            }
            searchRequest.setFilter(searchRequestDecorator.getFilterNode());
        }
    };
    private final GrammarAction extensibleMatchFilterCreation = new GrammarAction("Create Extensible Match Filter"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter();
            XmlPullParser xpp = container.getParser();
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            try {
                searchRequestDecorator.addCurrentFilter(extensibleMatchFilter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03012, new Object[0]), xpp, null);
            }
            searchRequestDecorator.setTerminalFilter(extensibleMatchFilter);
            String attributeValue = xpp.getAttributeValue("", "dnAttributes");
            if (attributeValue != null) {
                if (attributeValue.equals("true") || attributeValue.equals("1")) {
                    extensibleMatchFilter.setDnAttributes(true);
                } else {
                    if (!attributeValue.equals("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err(I18n.ERR_03033, new Object[0]), xpp, null);
                    extensibleMatchFilter.setDnAttributes(false);
                }
            } else {
                extensibleMatchFilter.setDnAttributes(false);
            }
            attributeValue = xpp.getAttributeValue("", "matchingRule");
            if (attributeValue != null) {
                extensibleMatchFilter.setMatchingRule(attributeValue);
            }
            if ((attributeValue = xpp.getAttributeValue("", "name")) == null) return;
            extensibleMatchFilter.setType(attributeValue);
        }
    };
    private final GrammarAction extensibleMatchAddValue = new GrammarAction("Adds Value to Extensible MatchFilter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestDsml searchRequestDecorator = (SearchRequestDsml)container.getBatchRequest().getCurrentRequest();
            ExtensibleMatchFilter filter = (ExtensibleMatchFilter)searchRequestDecorator.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        filter.setMatchValue(new BinaryValue(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        filter.setMatchValue(new StringValue(nextText.trim()));
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction controlCreation = new GrammarAction("Create Control"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "type");
            if (attributeValue != null) {
                if (!Oid.isOid(attributeValue)) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03034, new Object[0]), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03035, new Object[0]), xpp, null);
            }
            CodecControl<? extends Control> control = Dsmlv2Grammar.this.codec.newControl(Dsmlv2Grammar.this.codec.newControl(attributeValue));
            ((Request)((Object)container.getBatchRequest().getCurrentRequest())).addControl(control);
            attributeValue = xpp.getAttributeValue("", "criticality");
            if (attributeValue != null) {
                if (attributeValue.equals("true")) {
                    control.setCritical(true);
                } else if (attributeValue.equals("false")) {
                    control.setCritical(false);
                } else {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03007, new Object[0]), xpp, null);
                }
            }
        }
    };
    private final GrammarAction controlValueCreation = new GrammarAction("Add ControlValue to Control"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AbstractRequestDsml request = (AbstractRequestDsml)container.getBatchRequest().getCurrentRequest();
            DsmlControl<Control> control = request.getCurrentControl();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        control.setValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        control.setValue(nextText.trim().getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03008, e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction readSoapHeader = new GrammarAction("Reads SOAP header"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            try {
                XmlPullParser xpp = container.getParser();
                StringBuilder sb = new StringBuilder();
                String startTag = xpp.getText();
                sb.append(startTag);
                startTag = startTag.substring(1, startTag.length() - 1);
                int tagType = -1;
                String endTag = "";
                while (!startTag.equals(endTag)) {
                    tagType = xpp.next();
                    endTag = xpp.getText();
                    sb.append(endTag);
                    if (tagType != 3) continue;
                    endTag = endTag.substring(2, endTag.length() - 1);
                }
                container.setState(Dsmlv2StatesEnum.SOAP_HEADER_END_TAG);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };

    public Dsmlv2Grammar() {
        this.name = Dsmlv2Grammar.class.getName();
        this.transitions = (HashMap[])Array.newInstance(HashMap.class, 200);
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()].put(new Tag("batchRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE, Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, this.batchRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("batchRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("batchRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.GRAMMAR_END, null));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("abandonRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG, this.abandonRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("abandonRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG, this.abandonRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("addRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_START_TAG, this.addRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("addRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.ADD_REQUEST_START_TAG, this.addRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("authRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG, this.authRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("compareRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG, this.compareRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("compareRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG, this.compareRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("delRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.DEL_REQUEST_START_TAG, this.delRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("delRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.DEL_REQUEST_START_TAG, this.delRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("extendedRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG, this.extendedRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("extendedRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG, this.extendedRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("modDNRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG, this.modDNRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("modDNRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG, this.modDNRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("modifyRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG, this.modifyRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("modifyRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG, this.modifyRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_START_TAG.ordinal()].put(new Tag("searchRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG, this.searchRequestCreation));
        this.transitions[Dsmlv2StatesEnum.BATCHREQUEST_LOOP.ordinal()].put(new Tag("searchRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCHREQUEST_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG, this.searchRequestCreation));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG.ordinal()].put(new Tag("abandonRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_START_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("abandonRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.ABANDON_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_START_TAG.ordinal()].put(new Tag("addRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("addRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_START_TAG.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, this.addRequestAddAttribute));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, this.addRequestAddAttribute));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG, Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, this.addRequestAddAttribute));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG.ordinal()].put(new Tag("attr", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, Dsmlv2StatesEnum.ADD_REQUEST_ATTR_START_TAG, this.addRequestAddValue));
        this.transitions[Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG.ordinal()].put(new Tag("addRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.ADD_REQUEST_ATTR_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG.ordinal()].put(new Tag("authRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_START_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("authRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.AUTH_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_VALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("compareRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_START_TAG.ordinal()].put(new Tag("assertion", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_START_TAG, this.compareRequestAddAssertion));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("assertion", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_START_TAG, this.compareRequestAddAssertion));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_START_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_VALUE_END_TAG, this.compareRequestAddValue));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("assertion", 1), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_END_TAG.ordinal()].put(new Tag("compareRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.COMPARE_REQUEST_ASSERTION_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_START_TAG.ordinal()].put(new Tag("delRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_START_TAG, Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.DEL_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("delRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.DEL_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("extendedRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG.ordinal()].put(new Tag("requestName", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_START_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG, this.extendedRequestAddName));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("requestName", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG, this.extendedRequestAddName));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG.ordinal()].put(new Tag("extendedRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG.ordinal()].put(new Tag("requestValue", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTNAME_END_TAG, Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTVALUE_END_TAG, this.extendedRequestAddValue));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTVALUE_END_TAG.ordinal()].put(new Tag("extendedRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_REQUEST_REQUESTVALUE_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG.ordinal()].put(new Tag("modDNRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_START_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("modDNRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_DN_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG.ordinal()].put(new Tag("modifyRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("modifyRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("modification", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG, this.modifyRequestAddModification));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG.ordinal()].put(new Tag("modification", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG, this.modifyRequestAddModification));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG.ordinal()].put(new Tag("modification", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG, this.modifyRequestAddModification));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG.ordinal()].put(new Tag("modification", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_START_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG, this.modifyRequestAddValue));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG, this.modifyRequestAddValue));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("modification", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG.ordinal()].put(new Tag("modifyRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.MODIFY_REQUEST_MODIFICATION_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROLVALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROLVALUE_END_TAG, this.controlValueCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROLVALUE_END_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROLVALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_START_TAG, this.controlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("searchRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, this.storeFilter));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG.ordinal()].put(new Tag("attributes", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG.ordinal()].put(new Tag("attribute", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_START_TAG, this.searchRequestAddAttribute));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_START_TAG.ordinal()].put(new Tag("attribute", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG.ordinal()].put(new Tag("attribute", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_START_TAG, this.searchRequestAddAttribute));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG.ordinal()].put(new Tag("attributes", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_END_TAG.ordinal()].put(new Tag("searchRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, this.storeFilter));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EQUALITYMATCH_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_GREATEROREQUAL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_LESSOREQUAL_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_APPROXMATCH_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_PRESENT_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_VALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG.ordinal()].put(new Tag("filter", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG.ordinal()].put(new Tag("filter", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_CONTROL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("and", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.andFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("and", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.andFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("and", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.connectorFilterClose));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("or", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.orFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("or", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.orFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("or", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.connectorFilterClose));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("not", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.notFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("not", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.notFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("not", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.connectorFilterClose));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("substrings", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, this.substringsFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("substrings", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, this.substringsFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("equalityMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_EQUALITYMATCH_START_TAG, this.equalityMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("equalityMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_EQUALITYMATCH_START_TAG, this.equalityMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EQUALITYMATCH_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_EQUALITYMATCH_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, this.filterAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("equalityMatch", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("greaterOrEqual", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_GREATEROREQUAL_START_TAG, this.greaterOrEqualFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("greaterOrEqual", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_GREATEROREQUAL_START_TAG, this.greaterOrEqualFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_GREATEROREQUAL_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_GREATEROREQUAL_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, this.filterAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("greaterOrEqual", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("lessOrEqual", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_LESSOREQUAL_START_TAG, this.lessOrEqualFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("lessOrEqual", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_LESSOREQUAL_START_TAG, this.lessOrEqualFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_LESSOREQUAL_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_LESSOREQUAL_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, this.filterAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("lessOrEqual", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("approxMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_APPROXMATCH_START_TAG, this.approxMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("approxMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_APPROXMATCH_START_TAG, this.approxMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_APPROXMATCH_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_APPROXMATCH_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, this.filterAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG.ordinal()].put(new Tag("approxMatch", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_VALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("present", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_PRESENT_START_TAG, this.presentFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("present", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_PRESENT_START_TAG, this.presentFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_PRESENT_START_TAG.ordinal()].put(new Tag("present", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_PRESENT_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG.ordinal()].put(new Tag("extensibleMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_START_TAG, this.extensibleMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("extensibleMatch", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_START_TAG, this.extensibleMatchFilterCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_START_TAG.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_VALUE_END_TAG, this.extensibleMatchAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_VALUE_END_TAG.ordinal()].put(new Tag("extensibleMatch", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_EXTENSIBLEMATCH_VALUE_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP.ordinal()].put(new Tag("filter", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG.ordinal()].put(new Tag("attributes", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ATTRIBUTES_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG.ordinal()].put(new Tag("searchRequest", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_END_TAG, Dsmlv2StatesEnum.BATCHREQUEST_LOOP, this.storeFilter));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG.ordinal()].put(new Tag("substrings", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG.ordinal()].put(new Tag("initial", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG, this.substringsFilterSetInitial));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG.ordinal()].put(new Tag("any", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, this.substringsFilterAddAny));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG.ordinal()].put(new Tag("final", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG, this.substringsFilterSetFinal));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG.ordinal()].put(new Tag("substrings", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_INITIAL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.substringsFilterClose));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG.ordinal()].put(new Tag("any", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, this.substringsFilterAddAny));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG.ordinal()].put(new Tag("any", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, this.substringsFilterAddAny));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG.ordinal()].put(new Tag("final", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG, this.substringsFilterSetFinal));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG.ordinal()].put(new Tag("substrings", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_ANY_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.substringsFilterClose));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG.ordinal()].put(new Tag("final", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_SUBSTRINGS_START_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG, this.substringsFilterSetFinal));
        this.transitions[Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG.ordinal()].put(new Tag("substrings", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_REQUEST_FINAL_END_TAG, Dsmlv2StatesEnum.SEARCH_REQUEST_FILTER_LOOP, this.substringsFilterClose));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()].put(new Tag("envelope", 0), new GrammarTransition(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE, Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()].put(new Tag("header", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, Dsmlv2StatesEnum.SOAP_HEADER_START_TAG, this.readSoapHeader));
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_START_TAG.ordinal()].put(new Tag("header", 1), new GrammarTransition(Dsmlv2StatesEnum.SOAP_HEADER_START_TAG, Dsmlv2StatesEnum.SOAP_HEADER_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_END_TAG.ordinal()].put(new Tag("body", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_HEADER_END_TAG, Dsmlv2StatesEnum.SOAP_BODY_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_START_TAG.ordinal()].put(new Tag("batchRequest", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_BODY_START_TAG, Dsmlv2StatesEnum.BATCHREQUEST_START_TAG, this.batchRequestCreation));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()].put(new Tag("body", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, Dsmlv2StatesEnum.SOAP_BODY_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()].put(new Tag("body", 1), new GrammarTransition(Dsmlv2StatesEnum.GRAMMAR_END, Dsmlv2StatesEnum.GRAMMAR_END, null));
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()].put(new Tag("envelope", 1), new GrammarTransition(Dsmlv2StatesEnum.GRAMMAR_END, Dsmlv2StatesEnum.GRAMMAR_END, null));
    }

    public LdapApiService getLdapCodecService() {
        return this.codec;
    }
}

