/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.dsmlv2.request.AndFilter;
import org.apache.directory.shared.dsmlv2.request.AttributeValueAssertion;
import org.apache.directory.shared.dsmlv2.request.AttributeValueAssertionFilter;
import org.apache.directory.shared.dsmlv2.request.ConnectorFilter;
import org.apache.directory.shared.dsmlv2.request.ExtensibleMatchFilter;
import org.apache.directory.shared.dsmlv2.request.Filter;
import org.apache.directory.shared.dsmlv2.request.NotFilter;
import org.apache.directory.shared.dsmlv2.request.OrFilter;
import org.apache.directory.shared.dsmlv2.request.PresentFilter;
import org.apache.directory.shared.dsmlv2.request.SubstringFilter;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestDsml
extends AbstractResultResponseRequestDsml<SearchRequest, SearchResultDone>
implements SearchRequest {
    private Filter terminalFilter;
    private Filter currentFilter;
    private Filter topFilter;

    public SearchRequestDsml(LdapApiService codec) {
        super(codec, new SearchRequestImpl());
    }

    public SearchRequestDsml(LdapApiService codec, SearchRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public Filter getCodecFilter() {
        return this.topFilter;
    }

    public ExprNode getFilterNode() {
        return this.transform(this.topFilter);
    }

    public Filter getTerminalFilter() {
        return this.terminalFilter;
    }

    public void setTerminalFilter(Filter terminalFilter) {
        this.terminalFilter = terminalFilter;
    }

    public void setCurrentFilter(Filter filter) {
        this.currentFilter = filter;
    }

    public void addCurrentFilter(Filter localFilter) throws DecoderException {
        if (this.currentFilter != null) {
            ((ConnectorFilter)this.currentFilter).addFilter(localFilter);
            localFilter.setParent(this.currentFilter);
            if (localFilter instanceof ConnectorFilter) {
                this.currentFilter = localFilter;
            }
        } else {
            this.currentFilter = localFilter;
            this.currentFilter.setParent(null);
            this.topFilter = localFilter;
        }
    }

    private ExprNode transform(Filter filter) {
        if (filter != null) {
            if (filter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (filter instanceof AndFilter) {
                    branch = new AndNode();
                } else if (filter instanceof OrFilter) {
                    branch = new OrNode();
                } else if (filter instanceof NotFilter) {
                    branch = new NotNode();
                }
                List<Filter> filtersSet = ((ConnectorFilter)filter).getFilterSet();
                if (filtersSet != null) {
                    for (Filter node : filtersSet) {
                        branch.addNode(this.transform(node));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (filter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)filter).getAttributeDescription());
            } else if (filter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)filter).getAssertion();
                switch (((AttributeValueAssertionFilter)filter).getFilterType()) {
                    case 0: {
                        branch = new EqualityNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 1: {
                        branch = new GreaterEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 2: {
                        branch = new LessEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 3: {
                        branch = new ApproximateNode(ava.getAttributeDesc(), ava.getAssertionValue());
                    }
                }
            } else if (filter instanceof SubstringFilter) {
                SubstringFilter substrFilter = (SubstringFilter)filter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (substrFilter.getInitialSubstrings() != null) {
                    initialString = substrFilter.getInitialSubstrings();
                }
                if (substrFilter.getFinalSubstrings() != null) {
                    finalString = substrFilter.getFinalSubstrings();
                }
                if (substrFilter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : substrFilter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, substrFilter.getType(), initialString, finalString);
            } else if (filter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter extFilter = (ExtensibleMatchFilter)filter;
                String matchingRule = null;
                Value<?> value = extFilter.getMatchValue();
                if (extFilter.getMatchingRule() != null) {
                    matchingRule = extFilter.getMatchingRule();
                }
                branch = new ExtensibleNode(extFilter.getType(), value, matchingRule, extFilter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    @Override
    public MessageTypeEnum getType() {
        return ((SearchRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        SearchScope scope;
        Element element = super.toDsml(root);
        SearchRequest request = (SearchRequest)this.getDecorated();
        if (request.getBase() != null) {
            element.addAttribute("dn", request.getBase().getName());
        }
        if ((scope = request.getScope()) != null) {
            if (scope == SearchScope.OBJECT) {
                element.addAttribute("scope", "baseObject");
            } else if (scope == SearchScope.ONELEVEL) {
                element.addAttribute("scope", "singleLevel");
            } else if (scope == SearchScope.SUBTREE) {
                element.addAttribute("scope", "wholeSubtree");
            }
        }
        AliasDerefMode derefAliases = request.getDerefAliases();
        switch (derefAliases) {
            case NEVER_DEREF_ALIASES: {
                element.addAttribute("derefAliases", "neverDerefAliases");
                break;
            }
            case DEREF_ALWAYS: {
                element.addAttribute("derefAliases", "derefAlways");
                break;
            }
            case DEREF_FINDING_BASE_OBJ: {
                element.addAttribute("derefAliases", "derefFindingBaseObj");
                break;
            }
            case DEREF_IN_SEARCHING: {
                element.addAttribute("derefAliases", "derefInSearching");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected deref alias mode " + (Object)((Object)derefAliases));
            }
        }
        if (request.getSizeLimit() != 0L) {
            element.addAttribute("sizeLimit", "" + request.getSizeLimit());
        }
        if (request.getTimeLimit() != 0) {
            element.addAttribute("timeLimit", "" + request.getTimeLimit());
        }
        if (request.getTypesOnly()) {
            element.addAttribute("typesOnly", "true");
        }
        Element filterElement = element.addElement("filter");
        this.toDsml(filterElement, request.getFilter());
        List<String> attributes = request.getAttributes();
        if (attributes.size() > 0) {
            Element attributesElement = element.addElement("attributes");
            for (String entryAttribute : attributes) {
                attributesElement.addElement("attribute").addAttribute("name", entryAttribute);
            }
        }
        return element;
    }

    private void toDsml(Element element, ExprNode filter) {
        if (filter instanceof AndNode) {
            Element newElement = element.addElement("and");
            List<ExprNode> filterList = ((AndNode)filter).getChildren();
            for (int i = 0; i < filterList.size(); ++i) {
                this.toDsml(newElement, filterList.get(i));
            }
        } else if (filter instanceof OrNode) {
            Element newElement = element.addElement("or");
            List<ExprNode> filterList = ((OrNode)filter).getChildren();
            for (int i = 0; i < filterList.size(); ++i) {
                this.toDsml(newElement, filterList.get(i));
            }
        } else if (filter instanceof NotNode) {
            Element newElement = element.addElement("not");
            this.toDsml(newElement, ((NotNode)filter).getFirstChild());
        } else if (filter instanceof SubstringNode) {
            Element newElement = element.addElement("substrings");
            SubstringNode substringFilter = (SubstringNode)filter;
            newElement.addAttribute("name", substringFilter.getAttribute());
            String initial = substringFilter.getInitial();
            if (initial != null && !"".equals(initial)) {
                newElement.addElement("initial").setText(initial);
            }
            List<String> anyList = substringFilter.getAny();
            for (int i = 0; i < anyList.size(); ++i) {
                newElement.addElement("any").setText(anyList.get(i));
            }
            String finalString = substringFilter.getFinal();
            if (finalString != null && !"".equals(finalString)) {
                newElement.addElement("final").setText(finalString);
            }
        } else if (filter instanceof AttributeValueAssertionFilter) {
            AttributeValueAssertionFilter avaFilter = (AttributeValueAssertionFilter)((Object)filter);
            Element newElement = null;
            int filterType = avaFilter.getFilterType();
            if (filterType == 3) {
                newElement = element.addElement("approxMatch");
            } else if (filterType == 0) {
                newElement = element.addElement("equalityMatch");
            } else if (filterType == 1) {
                newElement = element.addElement("greaterOrEqual");
            } else if (filterType == 2) {
                newElement = element.addElement("lessOrEqual");
            }
            AttributeValueAssertion assertion = avaFilter.getAssertion();
            if (assertion != null) {
                newElement.addAttribute("name", assertion.getAttributeDesc());
                Value<?> value = assertion.getAssertionValue();
                if (value != null) {
                    if (ParserUtils.needsBase64Encoding(value)) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        element.getDocument().getRootElement().add(xsdNamespace);
                        element.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = newElement.addElement("value").addText(ParserUtils.base64Encode(value));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    } else {
                        newElement.addElement("value").setText(value.getString());
                    }
                }
            }
        } else if (filter instanceof PresentFilter) {
            Element newElement = element.addElement("present");
            newElement.addAttribute("name", ((PresentFilter)((Object)filter)).getAttributeDescription());
        } else if (filter instanceof ExtensibleMatchFilter) {
            String matchingRule;
            Element newElement = element.addElement("extensibleMatch");
            ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)((Object)filter);
            Value<?> value = extensibleMatchFilter.getMatchValue();
            if (value != null) {
                if (ParserUtils.needsBase64Encoding(value)) {
                    Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                    element.getDocument().getRootElement().add(xsdNamespace);
                    element.getDocument().getRootElement().add(xsiNamespace);
                    Element valueElement = newElement.addElement("value").addText(ParserUtils.base64Encode(value));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                } else {
                    newElement.addElement("value").setText(value.getString());
                }
            }
            if (extensibleMatchFilter.isDnAttributes()) {
                newElement.addAttribute("dnAttributes", "true");
            }
            if ((matchingRule = extensibleMatchFilter.getMatchingRule()) != null && "".equals(matchingRule)) {
                newElement.addAttribute("matchingRule", matchingRule);
            }
        }
    }

    @Override
    public MessageTypeEnum[] getResponseTypes() {
        return ((SearchRequest)this.getDecorated()).getResponseTypes();
    }

    @Override
    public Dn getBase() {
        return ((SearchRequest)this.getDecorated()).getBase();
    }

    @Override
    public SearchRequest setBase(Dn baseDn) {
        ((SearchRequest)this.getDecorated()).setBase(baseDn);
        return this;
    }

    @Override
    public SearchScope getScope() {
        return ((SearchRequest)this.getDecorated()).getScope();
    }

    @Override
    public SearchRequest setScope(SearchScope scope) {
        ((SearchRequest)this.getDecorated()).setScope(scope);
        return this;
    }

    @Override
    public AliasDerefMode getDerefAliases() {
        return ((SearchRequest)this.getDecorated()).getDerefAliases();
    }

    @Override
    public SearchRequest setDerefAliases(AliasDerefMode aliasDerefAliases) {
        ((SearchRequest)this.getDecorated()).setDerefAliases(aliasDerefAliases);
        return this;
    }

    @Override
    public long getSizeLimit() {
        return ((SearchRequest)this.getDecorated()).getSizeLimit();
    }

    @Override
    public SearchRequest setSizeLimit(long entriesMax) {
        ((SearchRequest)this.getDecorated()).setSizeLimit(entriesMax);
        return this;
    }

    @Override
    public int getTimeLimit() {
        return ((SearchRequest)this.getDecorated()).getTimeLimit();
    }

    @Override
    public SearchRequest setTimeLimit(int secondsMax) {
        ((SearchRequest)this.getDecorated()).setTimeLimit(secondsMax);
        return this;
    }

    @Override
    public boolean getTypesOnly() {
        return ((SearchRequest)this.getDecorated()).getTypesOnly();
    }

    @Override
    public SearchRequest setTypesOnly(boolean typesOnly) {
        ((SearchRequest)this.getDecorated()).setTypesOnly(typesOnly);
        return this;
    }

    @Override
    public ExprNode getFilter() {
        return ((SearchRequest)this.getDecorated()).getFilter();
    }

    @Override
    public SearchRequest setFilter(ExprNode filter) {
        ((SearchRequest)this.getDecorated()).setFilter(filter);
        return this;
    }

    @Override
    public SearchRequest setFilter(String filter) throws LdapException {
        ((SearchRequest)this.getDecorated()).setFilter(filter);
        return this;
    }

    @Override
    public List<String> getAttributes() {
        return ((SearchRequest)this.getDecorated()).getAttributes();
    }

    @Override
    public SearchRequest addAttributes(String ... attributes) {
        ((SearchRequest)this.getDecorated()).addAttributes(attributes);
        return this;
    }

    @Override
    public SearchRequest removeAttribute(String attribute) {
        ((SearchRequest)this.getDecorated()).removeAttribute(attribute);
        return this;
    }

    @Override
    public SearchRequest setMessageId(int messageId) {
        return (SearchRequest)super.setMessageId(messageId);
    }

    @Override
    public SearchRequest addControl(Control control) throws MessageException {
        return (SearchRequest)super.addControl(control);
    }

    @Override
    public SearchRequest addAllControls(Control[] controls) throws MessageException {
        return (SearchRequest)super.addAllControls(controls);
    }

    @Override
    public SearchRequest removeControl(Control control) throws MessageException {
        return (SearchRequest)super.removeControl(control);
    }
}

