/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncStateValueGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncStateValueGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new SyncStateValueGrammar();

    private SyncStateValueGrammar() {
        this.setName(SyncStateValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncStateValueStatesEnum.LAST_SYNC_STATE_VALUE_STATE.ordinal()][256];
        this.transitions[SyncStateValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SyncStateValueStatesEnum.START_STATE, SyncStateValueStatesEnum.SYNC_STATE_VALUE_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SyncStateValueStatesEnum.SYNC_STATE_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition<SyncStateValueContainer>(SyncStateValueStatesEnum.SYNC_STATE_VALUE_SEQUENCE_STATE, SyncStateValueStatesEnum.SYNC_TYPE_STATE, UniversalTag.ENUMERATED.getValue(), new GrammarAction<SyncStateValueContainer>("Set SyncStateValueControl state type"){

            @Override
            public void action(SyncStateValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int syncStateType = IntegerDecoder.parse(value, SyncStateTypeEnum.PRESENT.getValue(), SyncStateTypeEnum.MODDN.getValue());
                    SyncStateTypeEnum syncStateTypeEnum = SyncStateTypeEnum.getSyncStateType(syncStateType);
                    if (IS_DEBUG) {
                        LOG.debug("SyncStateType = {}", (Object)syncStateTypeEnum);
                    }
                    container.getSyncStateValueControl().setSyncStateType(syncStateTypeEnum);
                    container.setGrammarEndAllowed(false);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04030, new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncStateValueStatesEnum.SYNC_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncStateValueContainer>(SyncStateValueStatesEnum.SYNC_TYPE_STATE, SyncStateValueStatesEnum.SYNC_UUID_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncStateValueContainer>("Set SyncStateValueControl entryUUID"){

            @Override
            public void action(SyncStateValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                byte[] entryUUID = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("entryUUID = {}", (Object)Strings.dumpBytes(entryUUID));
                }
                container.getSyncStateValueControl().setEntryUUID(entryUUID);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncStateValueStatesEnum.SYNC_UUID_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncStateValueContainer>(SyncStateValueStatesEnum.SYNC_UUID_STATE, SyncStateValueStatesEnum.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncStateValueContainer>("Set SyncStateValueControl cookie value"){

            @Override
            public void action(SyncStateValueContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = {}", (Object)cookie);
                }
                container.getSyncStateValueControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar getInstance() {
        return instance;
    }
}

