/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message.controls;

import org.apache.directory.shared.ldap.model.message.controls.AbstractControl;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.message.controls.EntryChange;
import org.apache.directory.shared.ldap.model.name.Dn;

public class EntryChangeImpl
extends AbstractControl
implements EntryChange {
    private ChangeType changeType = ChangeType.ADD;
    private long changeNumber = -1L;
    private Dn previousDn = null;

    public EntryChangeImpl() {
        super("2.16.840.1.113730.3.4.7");
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public Dn getPreviousDn() {
        return this.previousDn;
    }

    public void setPreviousDn(Dn previousDn) {
        this.previousDn = previousDn;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + Long.valueOf(this.changeNumber).intValue();
        h = h * 37 + (this.changeType == null ? 0 : this.changeType.hashCode());
        h = h * 37 + (this.previousDn == null ? 0 : this.previousDn.hashCode());
        return h;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        EntryChange otherControl = (EntryChange)o;
        return this.changeNumber == otherControl.getChangeNumber() && this.changeType == otherControl.getChangeType() && this.previousDn.equals(otherControl.getPreviousDn());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Entry Change Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeType   : '").append((Object)this.changeType).append("'\n");
        sb.append("        previousDN   : '").append(this.previousDn).append("'\n");
        if (this.changeNumber == -1L) {
            sb.append("        changeNumber : '").append("UNDEFINED").append("'\n");
        } else {
            sb.append("        changeNumber : '").append(this.changeNumber).append("'\n");
        }
        return sb.toString();
    }
}

