/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.runtime.fs.hdfs.HadoopConfigLoader;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileSystemFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystemFactory.class);
    private final String name;
    private final HadoopConfigLoader hadoopConfigLoader;

    protected AbstractFileSystemFactory(String name, HadoopConfigLoader hadoopConfigLoader) {
        this.name = name;
        this.hadoopConfigLoader = hadoopConfigLoader;
    }

    public void configure(Configuration config) {
        this.hadoopConfigLoader.setFlinkConfig(config);
    }

    public org.apache.flink.core.fs.FileSystem create(URI fsUri) throws IOException {
        LOG.debug("Creating Hadoop file system (backed by " + this.name + ")");
        LOG.debug("Loading Hadoop configuration for " + this.name);
        try {
            org.apache.hadoop.conf.Configuration hadoopConfig = this.hadoopConfigLoader.getOrLoadHadoopConfig();
            FileSystem fs = this.createHadoopFileSystem();
            fs.initialize(this.getInitURI(fsUri, hadoopConfig), hadoopConfig);
            return new HadoopFileSystem(fs);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected abstract FileSystem createHadoopFileSystem();

    protected abstract URI getInitURI(URI var1, org.apache.hadoop.conf.Configuration var2);
}

