/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class RescalePartitioner<T>
extends StreamPartitioner<T> {
    private static final long serialVersionUID = 1L;
    private int nextChannelToSendTo = -1;

    public int selectChannel(SerializationDelegate<StreamRecord<T>> record) {
        if (++this.nextChannelToSendTo >= this.numberOfChannels) {
            this.nextChannelToSendTo = 0;
        }
        return this.nextChannelToSendTo;
    }

    @Override
    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.UNSUPPORTED;
    }

    @Override
    public SubtaskStateMapper getUpstreamSubtaskStateMapper() {
        return SubtaskStateMapper.UNSUPPORTED;
    }

    @Override
    public StreamPartitioner<T> copy() {
        return this;
    }

    public String toString() {
        return "RESCALE";
    }

    @Override
    public boolean isPointwise() {
        return true;
    }
}

