/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.security.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.Credentials;

public final class MarshalledCredentialBinding {
    private static final Logger LOG = LoggerFactory.getLogger(MarshalledCredentialBinding.class);
    @VisibleForTesting
    public static final String NO_AWS_CREDENTIALS = "No AWS credentials";

    private MarshalledCredentialBinding() {
    }

    public static MarshalledCredentials fromSTSCredentials(Credentials credentials) {
        MarshalledCredentials marshalled = new MarshalledCredentials(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken());
        Date date = Date.from(credentials.expiration());
        marshalled.setExpiration(date != null ? date.getTime() : 0L);
        return marshalled;
    }

    public static MarshalledCredentials fromAWSCredentials(AwsSessionCredentials credentials) {
        return new MarshalledCredentials(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken());
    }

    public static MarshalledCredentials fromEnvironment(Map<String, String> env) {
        return new MarshalledCredentials(MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_ACCESS_KEY")), MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_SECRET_KEY")), MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_SESSION_TOKEN")));
    }

    private static String nullToEmptyString(String src) {
        return src == null ? "" : src;
    }

    public static MarshalledCredentials fromFileSystem(URI uri, Configuration conf) throws IOException {
        String bucket = uri != null ? uri.getHost() : "";
        Configuration leanConf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
        return new MarshalledCredentials(S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.access.key"), S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.secret.key"), S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.session.token"));
    }

    public static AwsCredentials toAWSCredentials(MarshalledCredentials marshalled, MarshalledCredentials.CredentialTypeRequired typeRequired, String component) throws NoAuthWithAWSException, NoAwsCredentialsException {
        if (marshalled.isEmpty()) {
            throw new NoAwsCredentialsException(component, NO_AWS_CREDENTIALS);
        }
        if (!marshalled.isValid(typeRequired)) {
            throw new NoAuthWithAWSException(component + ":" + marshalled.buildInvalidCredentialsError(typeRequired));
        }
        String accessKey = marshalled.getAccessKey();
        String secretKey = marshalled.getSecretKey();
        if (marshalled.hasSessionToken()) {
            return AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)marshalled.getSessionToken());
        }
        return AwsBasicCredentials.create((String)accessKey, (String)secretKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MarshalledCredentials requestSessionCredentials(AwsCredentialsProvider parentCredentials, Configuration configuration, String stsEndpoint, String stsRegion, int duration, Invoker invoker, String bucket) throws IOException {
        try {
            StsClient tokenService = (StsClient)STSClientFactory.builder(parentCredentials, configuration, stsEndpoint.isEmpty() ? null : stsEndpoint, stsRegion, bucket).build();
            try (STSClientFactory.STSClient stsClient = STSClientFactory.createClientConnection(tokenService, invoker);){
                MarshalledCredentials marshalledCredentials = MarshalledCredentialBinding.fromSTSCredentials(stsClient.requestSessionCredentials(duration, TimeUnit.SECONDS));
                return marshalledCredentials;
            }
        }
        catch (SdkException e) {
            if (!stsRegion.isEmpty()) throw e;
            LOG.error("Region must be provided when requesting session credentials.", (Throwable)e);
            throw e;
        }
    }
}

