/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.actions.notinservicemenu.NotInServiceMenuFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ServiceActionsModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public final class ServiceActionUtil {
    private static final ActionLinkFactory linkAndLabelFactory = new ServiceActionLinkFactory();

    private ServiceActionUtil() {
    }

    static void addLeafItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        Fragment leafItem;
        if (!menuItem.isSeparator()) {
            leafItem = new Fragment("content", "leafItem", parent);
            AbstractLink subMenuItemLink = menuItem.getLink();
            Label menuItemLabel = new Label("menuLinkLabel", menuItem.getName());
            subMenuItemLink.addOrReplace(new Component[]{menuItemLabel});
            if (!menuItem.isEnabled()) {
                listItem.add(new Behavior[]{new CssClassAppender("disabled")});
                subMenuItemLink.setEnabled(false);
                TooltipBehavior tooltipBehavior = new TooltipBehavior((IModel)Model.of((Serializable)((Object)menuItem.getDisabledReason())));
                listItem.add(new Behavior[]{tooltipBehavior});
            }
            if (menuItem.isPrototyping()) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender("prototype")});
            }
            leafItem.add(new Component[]{subMenuItemLink});
            String cssClassFa = menuItem.getCssClassFa();
            if (Strings.isNullOrEmpty((String)cssClassFa)) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender("menuLinkSpacer")});
            } else {
                menuItemLabel.add(new Behavior[]{new CssClassFaBehavior(cssClassFa, menuItem.getCssClassFaPosition())});
            }
            String cssClass = menuItem.getCssClass();
            if (!Strings.isNullOrEmpty((String)cssClass)) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender(cssClass)});
            }
        } else {
            leafItem = new Fragment("content", "empty", parent);
            listItem.add(new Behavior[]{new CssClassAppender("divider")});
        }
        listItem.add(new Component[]{leafItem});
    }

    static List<CssMenuItem> withSeparators(CssMenuItem subMenuItem) {
        List<CssMenuItem> subMenuItems = subMenuItem.getSubMenuItems();
        List<CssMenuItem> cssMenuItemsWithSeparators = ServiceActionUtil.withSeparators(subMenuItems);
        subMenuItem.replaceSubMenuItems(cssMenuItemsWithSeparators);
        return cssMenuItemsWithSeparators;
    }

    static List<CssMenuItem> withSeparators(List<CssMenuItem> subMenuItems) {
        ArrayList itemsWithSeparators = Lists.newArrayList();
        for (CssMenuItem menuItem : subMenuItems) {
            if (menuItem.requiresSeparator()) {
                if (!itemsWithSeparators.isEmpty()) {
                    CssMenuItem separatorItem = CssMenuItem.newMenuItem(menuItem.getName() + "-separator").prototyping(menuItem.isPrototyping()).build();
                    separatorItem.setSeparator(true);
                    itemsWithSeparators.add(separatorItem);
                }
                menuItem.setRequiresSeparator(false);
            }
            itemsWithSeparators.add(menuItem);
        }
        return itemsWithSeparators;
    }

    static void addFolderItem(CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem, final MarkupContainer parent, SeparatorStrategy separatorStrategy) {
        listItem.add(new Behavior[]{new CssClassAppender("dropdown-submenu")});
        Fragment folderItem = new Fragment("content", "folderItem", parent);
        listItem.add(new Component[]{folderItem});
        folderItem.add(new Component[]{new Label("folderName", subMenuItem.getName())});
        List<CssMenuItem> menuItems = separatorStrategy.applySeparatorStrategy(subMenuItem);
        ListView<CssMenuItem> subMenuItemsView = new ListView<CssMenuItem>("subMenuItems", menuItems){

            protected void populateItem(ListItem<CssMenuItem> listItem) {
                CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
                if (subMenuItem.hasSubMenuItems()) {
                    ServiceActionUtil.addFolderItem(subMenuItem, listItem, parent, SeparatorStrategy.WITHOUT_SEPARATORS);
                } else {
                    ServiceActionUtil.addLeafItem(subMenuItem, listItem, parent);
                }
            }
        };
        folderItem.add(new Component[]{subMenuItemsView});
    }

    public static List<CssMenuItem> buildMenu(ServiceActionsModel appActionsModel) {
        List serviceAdapters = (List)appActionsModel.getObject();
        ArrayList serviceActions = Lists.newArrayList();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ServiceActionUtil.collateServiceActions(serviceAdapter, ActionType.USER, serviceActions);
            ServiceActionUtil.collateServiceActions(serviceAdapter, ActionType.PROTOTYPE, serviceActions);
        }
        Set<String> serviceNamesInOrder = ServiceActionUtil.serviceNamesInOrder(serviceAdapters, serviceActions);
        Map<String, List<LogicalServiceAction>> serviceActionsByName = ServiceActionUtil.groupByServiceName(serviceActions);
        serviceNamesInOrder.retainAll(serviceActionsByName.keySet());
        return ServiceActionUtil.buildMenuItems(serviceNamesInOrder, serviceActionsByName, linkAndLabelFactory);
    }

    private static List<CssMenuItem> buildMenuItems(Set<String> serviceNamesInOrder, Map<String, List<LogicalServiceAction>> serviceActionsByName, ActionLinkFactory actionLinkFactory) {
        ArrayList menuItems = Lists.newArrayList();
        for (String serviceName : serviceNamesInOrder) {
            CssMenuItem serviceMenuItem = CssMenuItem.newMenuItem(serviceName).build();
            List<LogicalServiceAction> serviceActionsForName = serviceActionsByName.get(serviceName);
            for (LogicalServiceAction logicalServiceAction : serviceActionsForName) {
                boolean separator;
                ObjectAction objectAction;
                ObjectAdapterMemento serviceAdapterMemento;
                CssMenuItem.Builder subMenuItemBuilder;
                ObjectAdapter serviceAdapter = logicalServiceAction.serviceAdapter;
                ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
                if (serviceSpec.isHidden() || (subMenuItemBuilder = serviceMenuItem.newSubMenuItem(serviceAdapterMemento = logicalServiceAction.serviceAdapterMemento, objectAction = logicalServiceAction.objectAction, separator = logicalServiceAction.separator, actionLinkFactory)) == null) continue;
                subMenuItemBuilder.build();
            }
            if (!serviceMenuItem.hasSubMenuItems()) continue;
            menuItems.add(serviceMenuItem);
        }
        return menuItems;
    }

    private static void collateServiceActions(ObjectAdapter serviceAdapter, ActionType actionType, List<LogicalServiceAction> serviceActions) {
        NatureOfService natureOfService;
        ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
        DomainServiceFacet domainServiceFacet = (DomainServiceFacet)serviceSpec.getFacet(DomainServiceFacet.class);
        if (domainServiceFacet != null && ((natureOfService = domainServiceFacet.getNatureOfService()) == NatureOfService.VIEW_REST_ONLY || natureOfService == NatureOfService.VIEW_CONTRIBUTIONS_ONLY || natureOfService == NatureOfService.DOMAIN)) {
            return;
        }
        for (ObjectAction objectAction : serviceSpec.getObjectActions(actionType, Contributed.INCLUDED, Filters.any())) {
            String serviceName;
            if (objectAction.getFacet(NotInServiceMenuFacet.class) != null) continue;
            MemberOrderFacet memberOrderFacet = (MemberOrderFacet)objectAction.getFacet(MemberOrderFacet.class);
            String string = serviceName = memberOrderFacet != null ? memberOrderFacet.name() : null;
            if (Strings.isNullOrEmpty((String)serviceName)) {
                serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            }
            serviceActions.add(new LogicalServiceAction(serviceName, serviceAdapter, objectAction));
        }
    }

    private static Set<String> serviceNamesInOrder(List<ObjectAdapter> serviceAdapters, List<LogicalServiceAction> serviceActions) {
        LinkedHashSet serviceNameOrder = Sets.newLinkedHashSet();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            ObjectSpecification serviceSpec = serviceAdapter.getSpecification();
            String serviceName = ((NamedFacet)serviceSpec.getFacet(NamedFacet.class)).value();
            serviceNameOrder.add(serviceName);
        }
        for (LogicalServiceAction serviceAction : serviceActions) {
            if (serviceNameOrder.contains(serviceAction.serviceName)) continue;
            serviceNameOrder.add(serviceAction.serviceName);
        }
        return serviceNameOrder;
    }

    private static Map<String, List<LogicalServiceAction>> groupByServiceName(List<LogicalServiceAction> serviceActions) {
        TreeMap serviceActionsByName = Maps.newTreeMap();
        ObjectAdapter lastServiceAdapter = null;
        for (LogicalServiceAction serviceAction : serviceActions) {
            List serviceActionsForName = (List)serviceActionsByName.get(serviceAction.serviceName);
            if (serviceActionsForName == null) {
                serviceActionsForName = Lists.newArrayList();
                serviceActionsByName.put(serviceAction.serviceName, serviceActionsForName);
            } else {
                serviceAction.separator = lastServiceAdapter != serviceAction.serviceAdapter;
            }
            serviceActionsForName.add(serviceAction);
            lastServiceAdapter = serviceAction.serviceAdapter;
        }
        return serviceActionsByName;
    }

    static class LogicalServiceAction {
        private final String serviceName;
        private final ObjectAdapter serviceAdapter;
        private final ObjectAdapterMemento serviceAdapterMemento;
        private final ObjectAction objectAction;
        public boolean separator;

        LogicalServiceAction(String serviceName, ObjectAdapter serviceAdapter, ObjectAction objectAction) {
            this.serviceName = serviceName;
            this.serviceAdapter = serviceAdapter;
            this.serviceAdapterMemento = ObjectAdapterMemento.createOrNull((ObjectAdapter)serviceAdapter);
            this.objectAction = objectAction;
        }

        public String toString() {
            return this.serviceName + " ~ " + this.objectAction.getIdentifier().toFullIdentityString();
        }
    }

    static enum SeparatorStrategy {
        WITH_SEPARATORS{

            @Override
            List<CssMenuItem> applySeparatorStrategy(CssMenuItem subMenuItem) {
                return ServiceActionUtil.withSeparators(subMenuItem);
            }
        }
        ,
        WITHOUT_SEPARATORS{

            @Override
            List<CssMenuItem> applySeparatorStrategy(CssMenuItem subMenuItem) {
                List<CssMenuItem> subMenuItems = subMenuItem.getSubMenuItems();
                return subMenuItems;
            }
        };


        abstract List<CssMenuItem> applySeparatorStrategy(CssMenuItem var1);
    }
}

