/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.selector;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.viewer.wicket.model.hints.IsisUiHintEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionSelectorPanel
extends PanelAbstract<EntityCollectionModel>
implements UiHintPathSignificant {
    private static final long serialVersionUID = 1L;
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_BUTTON_TITLE = "viewButtonTitle";
    private static final String ID_VIEW_BUTTON_ICON = "viewButtonIcon";
    private final CollectionSelectorHelper selectorHelper;
    private ComponentFactory selectedComponentFactory;

    public CollectionSelectorPanel(String id, EntityCollectionModel model) {
        super(id, model);
        this.selectorHelper = new CollectionSelectorHelper(model, this.getComponentFactoryRegistry());
    }

    public void onInitialize() {
        super.onInitialize();
        this.addDropdown();
    }

    private void addDropdown() {
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        int selected = this.selectorHelper.honourViewHintElseDefault((Component)this);
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_VIEWS);
        } else {
            Model componentFactoryModel = new Model();
            this.selectedComponentFactory = componentFactories.get(selected);
            componentFactoryModel.setObject((Serializable)this.selectedComponentFactory);
            final WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
            final Label viewButtonTitle = new Label(ID_VIEW_BUTTON_TITLE, "Hidden");
            views.addOrReplace(new Component[]{viewButtonTitle});
            final Label viewButtonIcon = new Label(ID_VIEW_BUTTON_ICON, "");
            views.addOrReplace(new Component[]{viewButtonIcon});
            WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
            views.addOrReplace(new Component[]{container});
            views.setOutputMarkupId(true);
            this.setOutputMarkupId(true);
            ListView<ComponentFactory> listView = new ListView<ComponentFactory>(ID_VIEW_ITEM, componentFactories){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<ComponentFactory> item) {
                    boolean isEnabled;
                    final int underlyingViewNum = item.getIndex();
                    final ComponentFactory componentFactory = (ComponentFactory)item.getModelObject();
                    AjaxLink<Void> link = new AjaxLink<Void>(CollectionSelectorPanel.ID_VIEW_LINK){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            CollectionSelectorPanel linksSelectorPanel = CollectionSelectorPanel.this;
                            linksSelectorPanel.setViewHintAndBroadcast(underlyingViewNum, target);
                            linksSelectorPanel.selectedComponentFactory = componentFactory;
                            target.add(new Component[]{linksSelectorPanel, views});
                        }

                        protected void onComponentTag(ComponentTag tag) {
                            super.onComponentTag(tag);
                            Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
                        }
                    };
                    IModel<String> title = this.nameFor(componentFactory);
                    Label viewItemTitleLabel = new Label(CollectionSelectorPanel.ID_VIEW_ITEM_TITLE, title);
                    link.add(new Component[]{viewItemTitleLabel});
                    Label viewItemIcon = new Label(CollectionSelectorPanel.ID_VIEW_ITEM_ICON, "");
                    link.add(new Component[]{viewItemIcon});
                    boolean bl = isEnabled = componentFactory != CollectionSelectorPanel.this.selectedComponentFactory;
                    if (!isEnabled) {
                        viewButtonTitle.setDefaultModel(title);
                        IModel<String> cssClass = this.cssClassFor(componentFactory, viewButtonIcon);
                        viewButtonIcon.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)("ViewLinkItem " + (String)cssClass.getObject())))});
                        link.setVisible(false);
                    } else {
                        IModel<String> cssClass = this.cssClassFor(componentFactory, viewItemIcon);
                        viewItemIcon.add(new Behavior[]{new CssClassAppender(cssClass)});
                    }
                    item.add(new Component[]{link});
                }

                private IModel<String> cssClassFor(ComponentFactory componentFactory, Label viewIcon) {
                    Model cssClass = null;
                    if (componentFactory instanceof CollectionContentsAsFactory) {
                        CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
                        cssClass = collectionContentsAsFactory.getCssClass();
                        viewIcon.setDefaultModelObject((Object)"");
                        viewIcon.setEscapeModelStrings(true);
                    }
                    if (cssClass == null) {
                        String name = componentFactory.getName();
                        cssClass = Model.of((Serializable)((Object)StringExtensions.asLowerDashed((String)name)));
                        viewIcon.setDefaultModelObject((Object)"&#160;&#160;&#160;&#160;&#160;");
                        viewIcon.setEscapeModelStrings(false);
                    }
                    return cssClass;
                }

                private IModel<String> nameFor(ComponentFactory componentFactory) {
                    Model name = null;
                    if (componentFactory instanceof CollectionContentsAsFactory) {
                        CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
                        name = collectionContentsAsFactory.getTitleLabel();
                    }
                    if (name == null) {
                        name = Model.of((Serializable)((Object)componentFactory.getName()));
                    }
                    return name;
                }
            };
            container.add(new Component[]{listView});
            this.addOrReplace(new Component[]{views});
        }
    }

    protected void setViewHintAndBroadcast(int viewNum, AjaxRequestTarget target) {
        EntityModel uiHintContainer = this.getUiHintContainer(((EntityCollectionModel)this.getModel()).isParented() ? EntityModel.class : EntityCollectionModel.class);
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, "view", "" + viewNum);
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisUiHintEvent((UiHintContainer)uiHintContainer, target));
    }
}

