/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.standalonecollection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.common.OnSelectionHandler;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StandaloneCollectionPanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider,
CollectionSelectorProvider,
BulkActionsProvider,
ActionPromptProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_ADDITIONAL_LINK = "additionalLink";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final ActionPromptModalWindow actionPromptModalWindow;
    private final CollectionSelectorPanel selectorDropdownPanel;
    private final BulkActionsHelper bulkActionsHelper;
    private boolean additionalLinksAdded;

    public StandaloneCollectionPanel(String id, EntityCollectionModel entityCollectionModel) {
        super(id, entityCollectionModel);
        ActionModel actionModel = entityCollectionModel.getActionModelHint();
        ObjectAction action = actionModel.getActionMemento().getAction();
        this.addOrReplace(new Component[]{new Label(ID_ACTION_NAME, (IModel)Model.of((Serializable)((Object)action.getName())))});
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.actionPromptModalWindow});
        CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper(entityCollectionModel, this.getComponentFactoryRegistry());
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_SELECTOR_DROPDOWN);
            this.selectorDropdownPanel = null;
        } else {
            CollectionSelectorPanel selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, entityCollectionModel);
            Model componentFactoryModel = new Model();
            int selected = selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanel);
            ComponentFactory selectedComponentFactory = componentFactories.get(selected);
            componentFactoryModel.setObject((Serializable)selectedComponentFactory);
            this.setOutputMarkupId(true);
            this.addOrReplace(new Component[]{selectorDropdownPanel});
            this.selectorDropdownPanel = selectorDropdownPanel;
        }
        ComponentFactoryRegistry componentFactoryRegistry = this.getComponentFactoryRegistry();
        componentFactoryRegistry.addOrReplaceComponent((MarkupContainer)this, ComponentType.COLLECTION_CONTENTS, (IModel<?>)entityCollectionModel);
        this.bulkActionsHelper = new BulkActionsHelper(entityCollectionModel);
    }

    public ActionPromptModalWindow getActionPrompt() {
        return ActionPromptModalWindow.getActionPromptModalWindowIfEnabled(this.actionPromptModalWindow);
    }

    @Override
    public ObjectAdapterToggleboxColumn createToggleboxColumn() {
        List<ObjectAction> bulkActions = this.bulkActionsHelper.getBulkActions();
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)this.getModel();
        if (bulkActions.isEmpty() || entityCollectionModel.isParented()) {
            return null;
        }
        ObjectAdapterToggleboxColumn toggleboxColumn = new ObjectAdapterToggleboxColumn();
        OnSelectionHandler handler = new OnSelectionHandler(){
            private static final long serialVersionUID = 1L;

            public void onSelected(Component context, ObjectAdapter selectedAdapter, AjaxRequestTarget ajaxRequestTarget) {
                ((EntityCollectionModel)StandaloneCollectionPanel.this.getModel()).toggleSelectionOn(selectedAdapter);
            }
        };
        toggleboxColumn.setOnSelectionHandler(handler);
        return toggleboxColumn;
    }

    @Override
    public void configureBulkActions(ObjectAdapterToggleboxColumn toggleboxColumn) {
        if (this.additionalLinksAdded) {
            return;
        }
        final BulkActionsLinkFactory linkFactory = new BulkActionsLinkFactory((EntityCollectionModel)this.getModel(), toggleboxColumn);
        List<ObjectAction> bulkActions = this.bulkActionsHelper.getBulkActions();
        List links = Lists.transform(bulkActions, (Function)new Function<ObjectAction, LinkAndLabel>(){

            public LinkAndLabel apply(ObjectAction objectAction) {
                return linkFactory.newLink(null, objectAction, StandaloneCollectionPanel.ID_ADDITIONAL_LINK);
            }
        });
        AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)this, ID_ADDITIONAL_LINKS, links, AdditionalLinksPanel.Style.INLINE_LIST);
        this.additionalLinksAdded = true;
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }
}

