/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.query.QueryResultImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;

public class QueryImpl
implements Query {
    private final Session session;
    private final ManagerProvider mgrProvider;
    private final ItemManager itemManager;
    private String statement;
    private String language;
    private Node node;
    private WorkspaceManager wspManager;
    private long limit = -1L;
    private long offset = -1L;
    private final Map<String, QValue> boundValues = new HashMap<String, QValue>();
    private final String[] varNameArray = new String[0];
    private final Collection<String> varNames = Collections.emptyList();

    public QueryImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager, String statement, String language, Node node) throws InvalidQueryException, RepositoryException {
        this.session = session;
        this.mgrProvider = mgrProvider;
        this.itemManager = itemMgr;
        this.statement = statement;
        this.language = language;
        this.wspManager = wspManager;
        this.node = node;
    }

    public QueryResult execute() throws RepositoryException {
        QueryInfo qI = this.wspManager.executeQuery(this.statement, this.language, this.getNamespaceMappings(), this.limit, this.offset, this.boundValues);
        return new QueryResultImpl(this.itemManager, this.mgrProvider, qI);
    }

    private Map<String, String> getNamespaceMappings() throws RepositoryException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String prefix : this.session.getNamespacePrefixes()) {
            mappings.put(prefix, this.session.getNamespaceURI(prefix));
        }
        return mappings;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        if (this.node == null) {
            throw new ItemNotFoundException("Not a persistent query.");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        NamePathResolver resolver = this.mgrProvider.getNamePathResolver();
        try {
            Path p = resolver.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String jcrParent = resolver.getJCRPath(p.getAncestor(1));
            if (!this.session.itemExists(jcrParent)) {
                throw new PathNotFoundException(jcrParent);
            }
            String relPath = resolver.getJCRPath(p).substring(1);
            String ntName = resolver.getJCRName(NameConstants.NT_QUERY);
            Node queryNode = this.session.getRootNode().addNode(relPath, ntName);
            queryNode.setProperty(resolver.getJCRName(NameConstants.JCR_LANGUAGE), this.getLanguage());
            queryNode.setProperty(resolver.getJCRName(NameConstants.JCR_STATEMENT), this.getStatement());
            this.node = queryNode;
            return this.node;
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return this.varNameArray;
    }

    public void bindValue(String varName, Value value) throws RepositoryException {
        if (!this.varNames.contains(varName)) {
            throw new IllegalArgumentException(varName + " is not a known bind variable name in this query");
        }
        if (value == null) {
            this.boundValues.remove(varName);
        } else {
            this.boundValues.put(varName, ValueFormat.getQValue((Value)value, (NamePathResolver)this.mgrProvider.getNamePathResolver(), (QValueFactory)this.mgrProvider.getQValueFactory()));
        }
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

